/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.engine;

import java.io.IOException;
import javax.servlet.ServletException;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.Gesture;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IEngineServiceView;
import net.sf.tapestry.IExternalPage;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.ResponseOutputStream;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.engine.AbstractService;

public class ExternalService
extends AbstractService {
    public Gesture buildGesture(IRequestCycle cycle, IComponent component, Object[] parameters) {
        if (parameters == null || parameters.length == 0) {
            throw new ApplicationRuntimeException(Tapestry.getString("service-requires-parameters", "external"));
        }
        String pageName = (String)parameters[0];
        String[] context = new String[]{pageName};
        Object[] pageParameters = new Object[parameters.length - 1];
        System.arraycopy(parameters, 1, pageParameters, 0, parameters.length - 1);
        return this.assembleGesture(cycle, "external", context, pageParameters, true);
    }

    public boolean service(IEngineServiceView engine, IRequestCycle cycle, ResponseOutputStream output) throws RequestCycleException, ServletException, IOException {
        IExternalPage page = null;
        String[] context = this.getServiceContext(cycle.getRequestContext());
        if (context == null || context.length != 1) {
            throw new ApplicationRuntimeException(Tapestry.getString("service-single-context-parameter", "external"));
        }
        String pageName = context[0];
        try {
            page = (IExternalPage)cycle.getPage(pageName);
        }
        catch (ClassCastException ex) {
            throw new ApplicationRuntimeException(Tapestry.getString("ExternalService.page-not-compatible", pageName), ex);
        }
        page.validate(cycle);
        cycle.setPage(page);
        Object[] parameters = this.getParameters(cycle);
        page.activateExternalPage(parameters, cycle);
        engine.renderResponse(cycle, output);
        return true;
    }

    public String getName() {
        return "external";
    }
}

