/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.event;

import java.io.Serializable;
import java.util.EventObject;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.Tapestry;

public class ObservedChangeEvent
extends EventObject {
    private IComponent component;
    private String propertyName;
    private Serializable newValue;

    public ObservedChangeEvent(IComponent component, String propertyName, char newValue) {
        this(component, propertyName, new Character(newValue));
    }

    public ObservedChangeEvent(IComponent component, String propertyName, byte newValue) {
        this(component, propertyName, new Byte(newValue));
    }

    public ObservedChangeEvent(IComponent component, String propertyName, short newValue) {
        this(component, propertyName, new Short(newValue));
    }

    public ObservedChangeEvent(IComponent component, String propertyName, int newValue) {
        this(component, propertyName, new Integer(newValue));
    }

    public ObservedChangeEvent(IComponent component, String propertyName, long newValue) {
        this(component, propertyName, new Long(newValue));
    }

    public ObservedChangeEvent(IComponent component, String propertyName, double newValue) {
        this(component, propertyName, new Double(newValue));
    }

    public ObservedChangeEvent(IComponent component, String propertyName, float newValue) {
        this(component, propertyName, new Float(newValue));
    }

    public ObservedChangeEvent(IComponent component, String propertyName, Object newValue) {
        super(component);
        if (propertyName == null) {
            throw new IllegalArgumentException(Tapestry.getString("ObservedChangeEvent.null-property-name", component));
        }
        if (newValue != null && !(newValue instanceof Serializable)) {
            throw new IllegalArgumentException(Tapestry.getString("ObservedChangeEvent.must-be-serializable"));
        }
        this.component = component;
        this.propertyName = propertyName;
        this.newValue = (Serializable)newValue;
    }

    public ObservedChangeEvent(IComponent component, String propertyName, boolean newValue) {
        this(component, propertyName, new Boolean(newValue));
    }

    public ObservedChangeEvent(IComponent component) {
        super(component);
        this.component = component;
    }

    public IComponent getComponent() {
        return this.component;
    }

    public Serializable getNewValue() {
        return this.newValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

