/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.form;

import java.awt.Point;
import net.sf.tapestry.IActionListener;
import net.sf.tapestry.IAsset;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IForm;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestContext;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.RequiredParameterException;
import net.sf.tapestry.form.AbstractFormComponent;

public class ImageSubmit
extends AbstractFormComponent {
    private IAsset _image;
    private IAsset _disabledImage;
    private Object _tag;
    private String _name;
    private String _nameOverride;
    private IActionListener _listener;
    private boolean _disabled;
    private IBinding _pointBinding;
    private IBinding _selectedBinding;

    public void setPointBinding(IBinding value) {
        this._pointBinding = value;
    }

    public IBinding getPointBinding() {
        return this._pointBinding;
    }

    public void setSelectedBinding(IBinding value) {
        this._selectedBinding = value;
    }

    public IBinding getSelectedBinding() {
        return this._selectedBinding;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        IForm form = this.getForm(cycle);
        boolean rewinding = form.isRewinding();
        this._name = this._nameOverride == null ? form.getElementId(this) : form.getElementId(this._nameOverride);
        if (rewinding) {
            String parameterName;
            if (this._disabled) {
                return;
            }
            RequestContext context = cycle.getRequestContext();
            String value = context.getParameter(parameterName = this._name + ".x");
            if (value == null) {
                return;
            }
            if (this._pointBinding != null) {
                int x = Integer.parseInt(value);
                parameterName = this._name + ".y";
                value = context.getParameter(parameterName);
                int y = Integer.parseInt(value);
                this._pointBinding.setObject(new Point(x, y));
            }
            if (this._selectedBinding != null) {
                this._selectedBinding.setObject(this._tag);
            }
            if (this._listener != null) {
                this._listener.actionTriggered(this, cycle);
            }
            return;
        }
        IAsset finalImage = this._disabled && this._disabledImage != null ? this._disabledImage : this._image;
        String imageURL = finalImage.buildURL(cycle);
        writer.beginEmpty("input");
        writer.attribute("type", "image");
        writer.attribute("name", this._name);
        if (this._disabled) {
            writer.attribute("disabled");
        }
        writer.attribute("border", 0);
        writer.attribute("src", imageURL);
        this.generateAttributes(writer, cycle);
        writer.closeTag();
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }

    public IAsset getDisabledImage() {
        return this._disabledImage;
    }

    public void setDisabledImage(IAsset disabledImage) {
        this._disabledImage = disabledImage;
    }

    public IAsset getImage() {
        return this._image;
    }

    public void setImage(IAsset image) {
        this._image = image;
    }

    public IActionListener getListener() {
        return this._listener;
    }

    public void setListener(IActionListener listener) {
        this._listener = listener;
    }

    public String getName() {
        return this._name;
    }

    public Object getTag() {
        return this._tag;
    }

    public void setTag(Object tag) {
        this._tag = tag;
    }

    public String getNameOverride() {
        return this._nameOverride;
    }

    public void setNameOverride(String nameOverride) {
        this._nameOverride = nameOverride;
    }

    protected void prepareForRender(IRequestCycle cycle) throws RequestCycleException {
        super.prepareForRender(cycle);
        if (this._image == null) {
            throw new RequiredParameterException(this, "image", this.getBinding("image"));
        }
    }
}

