/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.form;

import net.sf.tapestry.IBinding;
import net.sf.tapestry.IForm;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RenderOnlyPropertyException;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.form.AbstractFormComponent;

public class RadioGroup
extends AbstractFormComponent {
    private IBinding _selectedBinding;
    private boolean _disabled;
    private Object _selection;
    private int _selectedOption;
    private String _name;
    private boolean _rewinding;
    private boolean _rendering;
    private int _nextOptionId;
    private static final String ATTRIBUTE_NAME = "net.sf.tapestry.active.RadioGroup";

    public static RadioGroup get(IRequestCycle cycle) {
        return (RadioGroup)cycle.getAttribute(ATTRIBUTE_NAME);
    }

    public IBinding getSelectedBinding() {
        return this._selectedBinding;
    }

    public void setSelectedBinding(IBinding value) {
        this._selectedBinding = value;
    }

    public String getName() {
        return this._name;
    }

    public int getNextOptionId() {
        if (!this._rendering) {
            throw new RenderOnlyPropertyException(this, "nextOptionId");
        }
        return this._nextOptionId++;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public boolean isRewinding() {
        if (!this._rendering) {
            throw new RenderOnlyPropertyException(this, "rewinding");
        }
        return this._rewinding;
    }

    public boolean isSelection(Object value) {
        if (!this._rendering) {
            throw new RenderOnlyPropertyException(this, "selection");
        }
        if (this._selection == value) {
            return true;
        }
        if (this._selection == null || value == null) {
            return false;
        }
        return this._selection.equals(value);
    }

    public void updateSelection(Object value) {
        this._selectedBinding.setObject(value);
    }

    public boolean isSelected(int option) {
        return this._selectedOption == option;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        IForm form = this.getForm(cycle);
        if (cycle.getAttribute(ATTRIBUTE_NAME) != null) {
            throw new RequestCycleException(Tapestry.getString("RadioGroup.may-not-nest"), this);
        }
        this._rewinding = form.isRewinding();
        this._name = form.getElementId(this);
        cycle.setAttribute(ATTRIBUTE_NAME, this);
        if (this._rewinding) {
            String value = cycle.getRequestContext().getParameter(this._name);
            this._selectedOption = value == null ? -1 : Integer.parseInt(value);
        }
        try {
            this._rendering = true;
            this._nextOptionId = 0;
            if (!this._rewinding) {
                this._selection = this._selectedBinding.getObject();
            }
            this.renderBody(writer, cycle);
            Object var6_5 = null;
            this._rendering = false;
            this._selection = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._rendering = false;
            this._selection = null;
            throw throwable;
        }
        cycle.removeAttribute(ATTRIBUTE_NAME);
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }
}

