/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.form;

import net.sf.tapestry.IForm;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.form.AbstractFormComponent;

public class TextArea
extends AbstractFormComponent {
    private int _rows;
    private int _columns;
    private boolean _disabled;
    private String _name;
    private String _value;

    public String getName() {
        return this._name;
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        IForm form = this.getForm(cycle);
        boolean rewinding = form.isRewinding();
        this._name = form.getElementId(this);
        if (rewinding) {
            this._value = cycle.getRequestContext().getParameter(this._name);
            return;
        }
        writer.begin("textarea");
        writer.attribute("name", this._name);
        if (this._disabled) {
            writer.attribute("disabled");
        }
        if (this._rows != 0) {
            writer.attribute("rows", this._rows);
        }
        if (this._columns != 0) {
            writer.attribute("cols", this._columns);
        }
        this.generateAttributes(writer, cycle);
        if (this._value != null) {
            writer.print(this._value);
        }
        writer.end();
    }

    public int getColumns() {
        return this._columns;
    }

    public void setColumns(int columns) {
        this._columns = columns;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) {
        this._rows = rows;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String value) {
        this._value = value;
    }
}

