/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.html;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.tapestry.AbstractComponent;
import net.sf.tapestry.IAsset;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IPageSource;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.ScriptSession;
import net.sf.tapestry.Tapestry;

public class Body
extends AbstractComponent {
    private int _uniqueId;
    private StringBuffer _otherInitialization;
    private IMarkupWriter _outerWriter;
    private StringBuffer _otherScript;
    private StringBuffer _imageInitializations;
    private Map _imageMap;
    private Set _includedScripts;
    private String _element = "body";
    private static final String ATTRIBUTE_NAME = "net.sf.tapestry.active.Body";

    public String getPreloadedImageReference(String URL2) {
        String reference;
        if (this._imageMap == null) {
            this._imageMap = new HashMap();
        }
        if ((reference = (String)this._imageMap.get(URL2)) == null) {
            int count = this._imageMap.size();
            String varName = "tapestry_preload[" + count + "]";
            reference = varName + ".src";
            if (this._imageInitializations == null) {
                this._imageInitializations = new StringBuffer();
            }
            this._imageInitializations.append("  ");
            this._imageInitializations.append(varName);
            this._imageInitializations.append(" = new Image();\n");
            this._imageInitializations.append("  ");
            this._imageInitializations.append(reference);
            this._imageInitializations.append(" = \"");
            this._imageInitializations.append(URL2);
            this._imageInitializations.append("\";\n");
            this._imageMap.put(URL2, reference);
        }
        return reference;
    }

    public void addOtherInitialization(String script) {
        if (this._otherInitialization == null) {
            this._otherInitialization = new StringBuffer(script.length() + 1);
        }
        this._otherInitialization.append(script);
        this._otherInitialization.append('\n');
    }

    public void addOtherScript(String script) {
        if (this._otherScript == null) {
            this._otherScript = new StringBuffer(script.length());
        }
        this._otherScript.append(script);
    }

    public void includeScript(String URL2) {
        if (this._includedScripts == null) {
            this._includedScripts = new HashSet();
        }
        if (this._includedScripts.contains(URL2)) {
            return;
        }
        this._outerWriter.begin("script");
        this._outerWriter.attribute("language", "JavaScript");
        this._outerWriter.attribute("type", "text/javascript");
        this._outerWriter.attribute("src", URL2);
        this._outerWriter.end();
        this._outerWriter.println();
        this._includedScripts.add(URL2);
    }

    public static Body get(IRequestCycle cycle) {
        return (Body)cycle.getAttribute(ATTRIBUTE_NAME);
    }

    public String getUniqueId() {
        return Integer.toString(this._uniqueId++);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (cycle.getAttribute(ATTRIBUTE_NAME) != null) {
            throw new RequestCycleException(Tapestry.getString("Body.may-not-nest"), this);
        }
        cycle.setAttribute(ATTRIBUTE_NAME, this);
        this._uniqueId = 0;
        this._outerWriter = writer;
        try {
            IMarkupWriter nested = writer.getNestedWriter();
            this.renderBody(nested, cycle);
            String onLoadName = this.writeScript();
            writer.println();
            writer.begin("body");
            this.generateAttributes(writer, cycle);
            if (onLoadName != null) {
                writer.attribute("onLoad", "javascript:" + onLoadName + "();");
            }
            nested.close();
            writer.end();
            Object var6_5 = null;
            if (this._imageMap != null) {
                this._imageMap.clear();
            }
            if (this._includedScripts != null) {
                this._includedScripts.clear();
            }
            if (this._otherInitialization != null) {
                this._otherInitialization.setLength(0);
            }
            if (this._imageInitializations != null) {
                this._imageInitializations.setLength(0);
            }
            if (this._otherScript != null) {
                this._otherScript.setLength(0);
            }
            this._outerWriter = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this._imageMap != null) {
                this._imageMap.clear();
            }
            if (this._includedScripts != null) {
                this._includedScripts.clear();
            }
            if (this._otherInitialization != null) {
                this._otherInitialization.setLength(0);
            }
            if (this._imageInitializations != null) {
                this._imageInitializations.setLength(0);
            }
            if (this._otherScript != null) {
                this._otherScript.setLength(0);
            }
            this._outerWriter = null;
            throw throwable;
        }
    }

    private String writeScript() {
        if (!(this.any(this._otherInitialization) || this.any(this._otherScript) || this.any(this._imageInitializations))) {
            return null;
        }
        this._outerWriter.begin("script");
        this._outerWriter.attribute("language", "JavaScript");
        this._outerWriter.printRaw("<!--");
        if (this.any(this._imageInitializations)) {
            this._outerWriter.printRaw("\n\nvar tapestry_preload = new Array();\n");
            this._outerWriter.printRaw("if (document.images)\n");
            this._outerWriter.printRaw("{\n");
            this._outerWriter.printRaw(this._imageInitializations.toString());
            this._outerWriter.printRaw("}\n");
        }
        if (this.any(this._otherScript)) {
            this._outerWriter.printRaw("\n\n");
            this._outerWriter.printRaw(this._otherScript.toString());
        }
        String result = null;
        if (this.any(this._otherInitialization)) {
            result = "tapestry_onLoad";
            this._outerWriter.printRaw("\n\nfunction " + result + "()\n" + "{\n");
            this._outerWriter.printRaw(this._otherInitialization.toString());
            this._outerWriter.printRaw("}");
        }
        this._outerWriter.printRaw("\n\n// -->");
        this._outerWriter.end();
        return result;
    }

    private boolean any(StringBuffer buffer) {
        if (buffer == null) {
            return false;
        }
        return buffer.length() > 0;
    }

    public void process(ScriptSession session) {
        List includes;
        String initialization;
        String body = session.getBody();
        if (!Tapestry.isNull(body)) {
            this.addOtherScript(body);
        }
        if (!Tapestry.isNull(initialization = session.getInitialization())) {
            this.addOtherInitialization(initialization);
        }
        if ((includes = session.getIncludedScripts()) == null || includes.size() == 0) {
            return;
        }
        IRequestCycle cycle = this.getPage().getRequestCycle();
        IEngine engine = this.getPage().getEngine();
        IPageSource source = engine.getPageSource();
        Iterator i = includes.iterator();
        while (i.hasNext()) {
            String path = (String)i.next();
            IAsset asset = source.getPrivateAsset(path);
            String URL2 = asset.buildURL(cycle);
            this.includeScript(URL2);
        }
    }

    public String getElement() {
        return this._element;
    }

    public void setElement(String element) {
        this._element = element;
    }
}

