/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.html;

import java.util.Date;
import net.sf.tapestry.AbstractComponent;
import net.sf.tapestry.Gesture;
import net.sf.tapestry.IAsset;
import net.sf.tapestry.IEngineService;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IRender;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestContext;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;

public class Shell
extends AbstractComponent {
    private String _title;
    private IAsset _stylesheet;
    private IRender _delegate;
    private int _refresh;
    private String _DTD = "-//W3C//DTD HTML 4.0 Transitional//EN";
    private static final String generatorContent = "Tapestry Application Framework, version " + Tapestry.VERSION;

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        long startTime = 0L;
        boolean rewinding = cycle.isRewinding();
        if (!rewinding) {
            startTime = System.currentTimeMillis();
            if (!Tapestry.isNull(this._DTD)) {
                writer.printRaw("<!DOCTYPE HTML PUBLIC \"");
                writer.printRaw(this._DTD);
                writer.printRaw("\">");
                writer.println();
            }
            IPage page = this.getPage();
            writer.comment("Application: " + page.getEngine().getSpecification().getName());
            writer.comment("Page: " + page.getName());
            writer.comment("Generated: " + new Date());
            writer.begin("html");
            writer.println();
            writer.begin("head");
            writer.println();
            writer.beginEmpty("meta");
            writer.attribute("name", "generator");
            writer.attribute("content", generatorContent);
            writer.println();
            writer.begin("title");
            writer.print(this._title);
            writer.end();
            writer.println();
            if (this._delegate != null) {
                this._delegate.render(writer, cycle);
            }
            if (this._stylesheet != null) {
                writer.beginEmpty("link");
                writer.attribute("rel", "stylesheet");
                writer.attribute("type", "text/css");
                writer.attribute("href", this._stylesheet.buildURL(cycle));
                writer.println();
            }
            this.writeRefresh(writer, cycle);
            writer.end();
        }
        this.renderBody(writer, cycle);
        if (!rewinding) {
            writer.end();
            writer.println();
            long endTime = System.currentTimeMillis();
            writer.comment("Render time: ~ " + (endTime - startTime) + " ms");
        }
    }

    private void writeRefresh(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (this._refresh <= 0) {
            return;
        }
        RequestContext context = cycle.getRequestContext();
        IEngineService pageService = cycle.getEngine().getService("page");
        String pageName = this.getPage().getName();
        Gesture g = pageService.buildGesture(cycle, null, new String[]{pageName});
        StringBuffer buffer = new StringBuffer();
        buffer.append(this._refresh);
        buffer.append("; URL=");
        buffer.append(g.getAbsoluteURL());
        writer.beginEmpty("meta");
        writer.attribute("http-equiv", "Refresh");
        writer.attribute("content", buffer.toString());
    }

    public IRender getDelegate() {
        return this._delegate;
    }

    public void setDelegate(IRender delegate) {
        this._delegate = delegate;
    }

    public int getRefresh() {
        return this._refresh;
    }

    public void setRefresh(int refresh) {
        this._refresh = refresh;
    }

    public IAsset getStylesheet() {
        return this._stylesheet;
    }

    public void setStylesheet(IAsset stylesheet) {
        this._stylesheet = stylesheet;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    public String getDTD() {
        return this._DTD;
    }

    public void setDTD(String DTD) {
        this._DTD = DTD;
    }
}

