/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.inspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import net.sf.tapestry.BaseComponent;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.event.PageDetachListener;
import net.sf.tapestry.event.PageEvent;
import net.sf.tapestry.form.IPropertySelectionModel;
import net.sf.tapestry.inspector.LevelModel;
import net.sf.tapestry.valid.IField;
import net.sf.tapestry.valid.IValidationDelegate;
import net.sf.tapestry.valid.ValidationDelegate;
import net.sf.tapestry.valid.ValidatorException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ShowLogging
extends BaseComponent
implements PageDetachListener {
    private Logger _logger;
    private String _newLogger;
    private IValidationDelegate _validationDelegate;
    private IPropertySelectionModel _rootLevelModel;
    private IPropertySelectionModel _levelModel;

    protected void finishLoad() {
        this.getPage().addPageDetachListener(this);
    }

    public void pageDetached(PageEvent event) {
        this._logger = null;
        this._newLogger = null;
    }

    public String getNewLogger() {
        return this._newLogger;
    }

    public void setNewLogger(String value) {
        this._newLogger = value;
    }

    public void setLoggerName(String value) {
        this._logger = LogManager.getLogger((String)value);
    }

    public Logger getLogger() {
        return this._logger;
    }

    public List getLoggerNames() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration e = LogManager.getCurrentLoggers();
        while (e.hasMoreElements()) {
            Logger l = (Logger)e.nextElement();
            result.add(l.getName());
        }
        Collections.sort(result);
        return result;
    }

    public IPropertySelectionModel getRootLevelModel() {
        if (this._rootLevelModel == null) {
            this._rootLevelModel = new LevelModel(false);
        }
        return this._rootLevelModel;
    }

    public IPropertySelectionModel getLevelModel() {
        if (this._levelModel == null) {
            this._levelModel = new LevelModel();
        }
        return this._levelModel;
    }

    public IValidationDelegate getValidationDelegate() {
        if (this._validationDelegate == null) {
            this._validationDelegate = new ValidationDelegate();
        }
        return this._validationDelegate;
    }

    public void levelChange(IRequestCycle cycle) {
    }

    public void addNewLogger(IRequestCycle cycle) {
        IValidationDelegate delegate = (IValidationDelegate)this.getBeans().getBean("delegate");
        if (delegate.getHasErrors()) {
            return;
        }
        if (LogManager.exists((String)this._newLogger) == null) {
            LogManager.getLogger((String)this._newLogger);
            this._newLogger = null;
            return;
        }
        IField field = (IField)this.getComponent("inputNewLogger");
        delegate.setFormComponent(field);
        delegate.record(new ValidatorException("Logger " + this._newLogger + " already exists.", null, this._newLogger));
    }
}

