/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.inspector;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.tapestry.BaseComponent;
import net.sf.tapestry.IEngine;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IPageChange;
import net.sf.tapestry.IPageRecorder;
import net.sf.tapestry.event.PageEvent;
import net.sf.tapestry.event.PageRenderListener;
import net.sf.tapestry.inspector.Inspector;

public class ShowProperties
extends BaseComponent
implements PageRenderListener {
    private List _properties;
    private IPageChange _change;
    private IPage _inspectedPage;

    protected void finishLoad() {
        this.getPage().addPageRenderListener(this);
    }

    public void pageBeginRender(PageEvent event) {
    }

    public void pageEndRender(PageEvent event) {
        this._properties = null;
        this._change = null;
        this._inspectedPage = null;
    }

    private void buildProperties() {
        Inspector inspector = (Inspector)this.getPage();
        this._inspectedPage = inspector.getInspectedPage();
        IEngine engine = this.getPage().getEngine();
        IPageRecorder recorder = engine.getPageRecorder(this._inspectedPage.getName());
        if (recorder == null) {
            this._properties = Collections.EMPTY_LIST;
            return;
        }
        if (recorder.getHasChanges()) {
            this._properties = new ArrayList(recorder.getChanges());
        }
    }

    public List getProperties() {
        if (this._properties == null) {
            this.buildProperties();
        }
        return this._properties;
    }

    public void setChange(IPageChange value) {
        this._change = value;
    }

    public IPageChange getChange() {
        return this._change;
    }

    public String getValueClassName() {
        Object value = this._change.getNewValue();
        if (value == null) {
            return "<null>";
        }
        return this.convertClassToName(value.getClass());
    }

    private String convertClassToName(Class cl) {
        if (cl.isArray()) {
            return "array of " + cl.getComponentType().getName();
        }
        return cl.getName();
    }
}

