/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.inspector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.sf.tapestry.BaseComponent;
import net.sf.tapestry.IAsset;
import net.sf.tapestry.IBinding;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.event.PageEvent;
import net.sf.tapestry.event.PageRenderListener;
import net.sf.tapestry.inspector.Inspector;
import net.sf.tapestry.spec.BeanSpecification;
import net.sf.tapestry.spec.ComponentSpecification;
import net.sf.tapestry.spec.ContainedComponent;
import net.sf.tapestry.spec.ParameterSpecification;

public class ShowSpecification
extends BaseComponent
implements PageRenderListener {
    private IComponent _inspectedComponent;
    private ComponentSpecification _inspectedSpecification;
    private String _parameterName;
    private String _assetName;
    private List _sortedComponents;
    private IComponent _component;
    private List _assetNames;
    private List _formalParameterNames;
    private List _informalParameterNames;
    private List _sortedPropertyNames;
    private String _propertyName;
    private List _beanNames;
    private String _beanName;
    private BeanSpecification _beanSpecification;

    protected void finishLoad() {
        this.getPage().addPageRenderListener(this);
    }

    public void pageEndRender(PageEvent event) {
        this._inspectedComponent = null;
        this._inspectedSpecification = null;
        this._parameterName = null;
        this._assetName = null;
        this._sortedComponents = null;
        this._component = null;
        this._assetNames = null;
        this._formalParameterNames = null;
        this._informalParameterNames = null;
        this._sortedPropertyNames = null;
        this._propertyName = null;
        this._beanNames = null;
        this._beanName = null;
        this._beanSpecification = null;
    }

    public void pageBeginRender(PageEvent event) {
        Inspector inspector = (Inspector)this.getPage();
        this._inspectedComponent = inspector.getInspectedComponent();
        this._inspectedSpecification = this._inspectedComponent.getSpecification();
    }

    public IComponent getInspectedComponent() {
        return this._inspectedComponent;
    }

    public ComponentSpecification getInspectedSpecification() {
        return this._inspectedSpecification;
    }

    public List getFormalParameterNames() {
        if (this._formalParameterNames != null) {
            return this._formalParameterNames;
        }
        List names = this._inspectedSpecification.getParameterNames();
        if (names != null && names.size() > 0) {
            this._formalParameterNames = new ArrayList(names);
            Collections.sort(this._formalParameterNames);
        }
        return this._formalParameterNames;
    }

    public List getInformalParameterNames() {
        if (this._informalParameterNames != null) {
            return this._informalParameterNames;
        }
        Collection names = this._inspectedComponent.getBindingNames();
        if (names != null && names.size() > 0) {
            this._informalParameterNames = new ArrayList(names);
            names = this._inspectedSpecification.getParameterNames();
            if (names != null) {
                this._informalParameterNames.removeAll(names);
            }
            Collections.sort(this._informalParameterNames);
        }
        return this._informalParameterNames;
    }

    public String getParameterName() {
        return this._parameterName;
    }

    public void setParameterName(String value) {
        this._parameterName = value;
    }

    public ParameterSpecification getParameterSpecification() {
        return this._inspectedSpecification.getParameter(this._parameterName);
    }

    public IBinding getBinding() {
        return this._inspectedComponent.getBinding(this._parameterName);
    }

    public void setAssetName(String value) {
        this._assetName = value;
    }

    public String getAssetName() {
        return this._assetName;
    }

    public IAsset getAsset() {
        return (IAsset)this._inspectedComponent.getAssets().get(this._assetName);
    }

    public List getAssetNames() {
        if (this._assetNames != null) {
            return this._assetNames;
        }
        Map assets = this._inspectedComponent.getAssets();
        this._assetNames = new ArrayList(assets.keySet());
        Collections.sort(this._assetNames);
        return this._assetNames;
    }

    public List getSortedComponents() {
        if (this._sortedComponents != null) {
            return this._sortedComponents;
        }
        Inspector inspector = (Inspector)this.getPage();
        IComponent inspectedComponent = inspector.getInspectedComponent();
        Map components = inspectedComponent.getComponents();
        this._sortedComponents = new ArrayList(components.values());
        Collections.sort(this._sortedComponents, new ComponentComparitor());
        return this._sortedComponents;
    }

    public void setComponent(IComponent value) {
        this._component = value;
    }

    public IComponent getComponent() {
        return this._component;
    }

    public String getComponentType() {
        IComponent container = this._component.getContainer();
        ComponentSpecification containerSpecification = container.getSpecification();
        String id = this._component.getId();
        ContainedComponent contained = containerSpecification.getComponent(id);
        return contained.getType();
    }

    public List getSortedPropertyNames() {
        if (this._sortedPropertyNames != null) {
            return this._sortedPropertyNames;
        }
        List names = this._inspectedSpecification.getPropertyNames();
        if (names != null && names.size() > 0) {
            this._sortedPropertyNames = new ArrayList(names);
            Collections.sort(this._sortedPropertyNames);
        }
        return this._sortedPropertyNames;
    }

    public void setPropertyName(String value) {
        this._propertyName = value;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public String getPropertyValue() {
        return this._inspectedSpecification.getProperty(this._propertyName);
    }

    public List getBeanNames() {
        if (this._beanNames != null) {
            return this._beanNames;
        }
        Collection names = this._inspectedSpecification.getBeanNames();
        if (names != null && names.size() > 0) {
            this._beanNames = new ArrayList(names);
            Collections.sort(this._beanNames);
        }
        return this._beanNames;
    }

    public void setBeanName(String value) {
        this._beanName = value;
        this._beanSpecification = this._inspectedSpecification.getBeanSpecification(this._beanName);
    }

    public String getBeanName() {
        return this._beanName;
    }

    public BeanSpecification getBeanSpecification() {
        return this._beanSpecification;
    }

    private static class ComponentComparitor
    implements Comparator {
        private ComponentComparitor() {
        }

        public int compare(Object left, Object right) {
            if (left == right) {
                return 0;
            }
            IComponent leftComponent = (IComponent)left;
            IComponent rightComponent = (IComponent)right;
            String leftId = leftComponent.getId();
            String rightId = rightComponent.getId();
            return leftId.compareTo(rightId);
        }
    }
}

