/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.inspector;

import net.sf.tapestry.BaseComponent;
import net.sf.tapestry.IAsset;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.inspector.Inspector;
import net.sf.tapestry.inspector.View;

public class ViewTabs
extends BaseComponent {
    private static View[] views = new View[]{View.SPECIFICATION, View.TEMPLATE, View.PROPERTIES, View.ENGINE, View.LOGGING};
    private View view;

    public View[] getViews() {
        return views;
    }

    public void setView(View value) {
        this.view = value;
    }

    public View getView() {
        return this.view;
    }

    private IAsset getImageForView(boolean focus) {
        Inspector inspector = (Inspector)this.getPage();
        boolean selected = this.view == inspector.getView();
        StringBuffer buffer = new StringBuffer(this.view.getEnumerationId());
        if (selected) {
            buffer.append("_selected");
        }
        if (focus) {
            buffer.append("_focus");
        }
        String key = buffer.toString();
        return (IAsset)this.getAssets().get(key);
    }

    public IAsset getViewImage() {
        return this.getImageForView(false);
    }

    public IAsset getFocusImage() {
        return this.getImageForView(true);
    }

    public IAsset getBannerImage() {
        Inspector inspector = (Inspector)this.getPage();
        View selectedView = inspector.getView();
        String key = selectedView.getEnumerationId() + "_banner";
        return (IAsset)this.getAssets().get(key);
    }

    public void selectTab(IRequestCycle cycle) {
        Inspector inspector = (Inspector)this.getPage();
        inspector.setView(this.view);
    }
}

