/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.link;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.tapestry.AbstractComponent;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.components.IServiceLink;
import net.sf.tapestry.components.ServiceLinkEventType;
import net.sf.tapestry.html.Body;

public abstract class AbstractServiceLink
extends AbstractComponent
implements IServiceLink {
    private boolean disabled;
    protected Body body;
    protected static final int MAP_SIZE = 3;
    protected Map eventHandlers;

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void addEventHandler(ServiceLinkEventType eventType, String functionName) {
        Object currentValue;
        if (this.eventHandlers == null) {
            this.eventHandlers = new HashMap(3);
        }
        if ((currentValue = this.eventHandlers.get(eventType)) == null) {
            this.eventHandlers.put(eventType, functionName);
            return;
        }
        if (currentValue instanceof String) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(currentValue);
            list.add(functionName);
            this.eventHandlers.put(eventType, list);
            return;
        }
        List list = (List)currentValue;
        list.add(functionName);
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        IMarkupWriter wrappedWriter;
        if (cycle.getAttribute("net.sf.tapestry.active.IServiceLink") != null) {
            throw new RequestCycleException(Tapestry.getString("AbstractServiceLink.no-nesting"), this);
        }
        this.body = Body.get(cycle);
        cycle.setAttribute("net.sf.tapestry.active.IServiceLink", this);
        if (!this.disabled) {
            writer.begin("a");
            writer.attribute("href", this.getURL(cycle));
            wrappedWriter = writer.getNestedWriter();
        } else {
            wrappedWriter = writer;
        }
        this.renderBody(wrappedWriter, cycle);
        if (!this.disabled) {
            this.writeEventHandlers(writer);
            this.generateAttributes(writer, cycle);
            wrappedWriter.close();
            writer.end();
        }
        cycle.removeAttribute("net.sf.tapestry.active.IServiceLink");
    }

    protected void cleanupAfterRender(IRequestCycle cycle) {
        this.eventHandlers = null;
        this.body = null;
        super.cleanupAfterRender(cycle);
    }

    protected void writeEventHandlers(IMarkupWriter writer) throws RequestCycleException {
        String name = null;
        if (this.eventHandlers == null) {
            return;
        }
        Iterator i = this.eventHandlers.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ServiceLinkEventType type = (ServiceLinkEventType)entry.getKey();
            name = this.writeEventHandler(writer, name, type.getAttributeName(), entry.getValue());
        }
    }

    protected String writeEventHandler(IMarkupWriter writer, String name, String attributeName, Object value) throws RequestCycleException {
        String wrapperFunctionName;
        if (value instanceof String) {
            wrapperFunctionName = (String)value;
        } else {
            if (this.body == null) {
                throw new RequestCycleException(Tapestry.getString("AbstractServiceLink.events-need-body"), this, null);
            }
            if (name == null) {
                name = "Link" + this.body.getUniqueId();
            }
            wrapperFunctionName = attributeName + "_" + name;
            StringBuffer buffer = new StringBuffer();
            buffer.append("function ");
            buffer.append(wrapperFunctionName);
            buffer.append(" ()\n{\n");
            Iterator i = ((List)value).iterator();
            while (i.hasNext()) {
                String functionName = (String)i.next();
                buffer.append("  ");
                buffer.append(functionName);
                buffer.append("();\n");
            }
            buffer.append("}\n\n");
            this.body.addOtherScript(buffer.toString());
        }
        writer.attribute(attributeName, "javascript:" + wrapperFunctionName + "();");
        return name;
    }

    protected abstract String getURL(IRequestCycle var1) throws RequestCycleException;
}

