/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.multipart;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

class UploadOutputStream
extends OutputStream {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$multipart$UploadOutputStream == null ? (class$net$sf$tapestry$multipart$UploadOutputStream = UploadOutputStream.class$("net.sf.tapestry.multipart.UploadOutputStream")) : class$net$sf$tapestry$multipart$UploadOutputStream));
    public static final int DEFAULT_LIMIT = 2000;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private OutputStream active = this.baos;
    private int limit;
    private int count = 0;
    private FileOutputStream fos;
    private File file;
    static /* synthetic */ Class class$net$sf$tapestry$multipart$UploadOutputStream;

    UploadOutputStream() {
        this(2000);
    }

    UploadOutputStream(int limit) {
        this.limit = limit;
    }

    public void close() throws IOException {
        this.active.close();
    }

    public void flush() throws IOException {
        this.active.close();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.check(len);
        this.active.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        this.check(1);
        this.active.write(b);
    }

    private void check(int length) throws IOException {
        if (this.fos != null) {
            return;
        }
        this.count += length;
        if (this.count < this.limit) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Limit of " + this.limit + " bytes reached."));
        }
        this.file = File.createTempFile("upload-", ".bin");
        this.fos = new FileOutputStream(this.file);
        this.baos.close();
        this.baos.writeTo(this.fos);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Writing upload content to " + this.file + "."));
        }
        this.baos = null;
        this.active = this.fos;
    }

    public File getContentFile() {
        return this.file;
    }

    public byte[] getContent() {
        return this.baos.toByteArray();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

