/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.parse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.parse.ITemplateParserDelegate;
import net.sf.tapestry.parse.TemplateParseException;
import net.sf.tapestry.parse.TemplateToken;
import net.sf.tapestry.parse.TokenType;

public class TemplateParser {
    private static final String REMOVE_ID = "$remove$";
    private static final String CONTENT_ID = "$content$";
    public static final String LOCALIZATION_KEY_ATTRIBUTE_NAME = "key";
    private ITemplateParserDelegate delegate;
    private String resourcePath;
    private char[] templateData;
    private List stack = new ArrayList();
    private List tokens = new ArrayList();
    private int cursor;
    private int blockStart;
    private int line;
    private boolean ignoring;
    private Map attributes = new HashMap();
    private static final char[] COMMENT_START = new char[]{'<', '!', '-', '-'};
    private static final char[] COMMENT_END = new char[]{'-', '-', '>'};
    private static final char[] CLOSE_TAG = new char[]{'<', '/'};
    private static final int WAIT_FOR_ATTRIBUTE_NAME = 0;
    private static final int COLLECT_ATTRIBUTE_NAME = 1;
    private static final int ADVANCE_PAST_EQUALS = 2;
    private static final int WAIT_FOR_ATTRIBUTE_VALUE = 3;
    private static final int COLLECT_QUOTED_VALUE = 4;
    private static final int COLLECT_UNQUOTED_VALUE = 5;

    public TemplateToken[] parse(char[] templateData, ITemplateParserDelegate delegate, String resourcePath) throws TemplateParseException {
        TemplateToken[] result = null;
        try {
            this.templateData = templateData;
            this.resourcePath = resourcePath;
            this.delegate = delegate;
            this.ignoring = false;
            this.line = 1;
            this.parse();
            result = this.tokens.toArray(new TemplateToken[this.tokens.size()]);
            Object var6_5 = null;
            this.delegate = null;
            this.templateData = null;
            this.resourcePath = null;
            this.stack.clear();
            this.tokens.clear();
            this.attributes.clear();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.delegate = null;
            this.templateData = null;
            this.resourcePath = null;
            this.stack.clear();
            this.tokens.clear();
            this.attributes.clear();
            throw throwable;
        }
        return result;
    }

    private boolean lookahead(char[] match) {
        try {
            int i = 0;
            while (i < match.length) {
                if (this.templateData[this.cursor + i] != match[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (IndexOutOfBoundsException ex) {
            return false;
        }
    }

    private void parse() throws TemplateParseException {
        this.cursor = 0;
        this.blockStart = -1;
        int length = this.templateData.length;
        while (this.cursor < length) {
            if (this.templateData[this.cursor] != '<') {
                if (this.blockStart < 0 && !this.ignoring) {
                    this.blockStart = this.cursor;
                }
                this.advance();
                continue;
            }
            if (this.lookahead(CLOSE_TAG)) {
                this.closeTag();
                continue;
            }
            if (this.lookahead(COMMENT_START)) {
                this.skipComment();
                continue;
            }
            this.startTag();
        }
        this.addTextToken(this.templateData.length - 1);
    }

    private void skipComment() throws TemplateParseException {
        int length = this.templateData.length;
        int startLine = this.line;
        if (this.blockStart < 0 && !this.ignoring) {
            this.blockStart = this.cursor;
        }
        while (true) {
            if (this.cursor >= length) {
                throw new TemplateParseException(Tapestry.getString("TemplateParser.comment-not-ended", Integer.toString(startLine)), startLine, this.resourcePath);
            }
            if (this.lookahead(COMMENT_END)) break;
            this.advance();
        }
        this.cursor += COMMENT_END.length;
        this.advanceOverWhitespace();
    }

    private void addTextToken(int end) {
        if (this.blockStart < 0) {
            return;
        }
        if (this.blockStart <= end) {
            TemplateToken token = new TemplateToken(this.templateData, this.blockStart, end);
            this.tokens.add(token);
        }
        this.blockStart = -1;
    }

    private void startTag() throws TemplateParseException {
        int cursorStart = this.cursor;
        int length = this.templateData.length;
        String tagName = null;
        boolean endOfTag = false;
        boolean emptyTag = false;
        int startLine = this.line;
        this.advance();
        while (this.cursor < length) {
            char ch = this.templateData[this.cursor];
            if (ch == '/' || ch == '>' || Character.isWhitespace(ch)) {
                tagName = new String(this.templateData, cursorStart + 1, this.cursor - cursorStart - 1);
                break;
            }
            this.advance();
        }
        boolean isJwcTag = tagName != null && tagName.equalsIgnoreCase("jwc");
        String jwcId = null;
        String jwcIdAttributeName = isJwcTag ? "id" : "jwcid";
        String attributeName = null;
        String localizationKey = null;
        int attributeNameStart = -1;
        int attributeValueStart = -1;
        int state = 0;
        char quoteChar = '\u0000';
        this.attributes.clear();
        while (!endOfTag) {
            if (this.cursor >= length) {
                String key = tagName == null ? "TemplateParser.unclosed-unknown-tag" : "TemplateParser.unclosed-tag";
                throw new TemplateParseException(Tapestry.getString(key, tagName, Integer.toString(startLine)), startLine, this.resourcePath);
            }
            char ch = this.templateData[this.cursor];
            switch (state) {
                case 0: {
                    if (ch == '/') {
                        emptyTag = true;
                        this.advance();
                        break;
                    }
                    if (ch == '>') {
                        endOfTag = true;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        this.advance();
                        break;
                    }
                    attributeNameStart = this.cursor;
                    state = 1;
                    this.advance();
                    break;
                }
                case 1: {
                    if (ch == '=' || ch == '/' || ch == '>' || Character.isWhitespace(ch)) {
                        attributeName = new String(this.templateData, attributeNameStart, this.cursor - attributeNameStart);
                        if (isJwcTag && !attributeName.equalsIgnoreCase(jwcIdAttributeName)) {
                            throw new TemplateParseException(Tapestry.getString("TemplateParser.unexpected-attribute", tagName, Integer.toString(startLine), jwcIdAttributeName), startLine, this.resourcePath);
                        }
                        state = 2;
                        break;
                    }
                    this.advance();
                    break;
                }
                case 2: {
                    if (ch == '/' || ch == '>') {
                        state = 0;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        this.advance();
                        break;
                    }
                    if (ch == '=') {
                        state = 3;
                        quoteChar = '\u0000';
                        attributeValueStart = -1;
                        this.advance();
                        break;
                    }
                    state = 0;
                    break;
                }
                case 3: {
                    if (ch == '/' || ch == '>') {
                        throw new TemplateParseException(Tapestry.getString("TemplateParser.missing-attiribute-value", tagName, Integer.toString(this.line), attributeName), this.line, this.resourcePath);
                    }
                    if (Character.isWhitespace(ch)) {
                        this.advance();
                        break;
                    }
                    if (ch == '\'' || ch == '\"') {
                        quoteChar = ch;
                        state = 4;
                        this.advance();
                        attributeValueStart = this.cursor;
                        break;
                    }
                    state = 5;
                    attributeValueStart = this.cursor;
                    break;
                }
                case 4: {
                    String attributeValue;
                    if (ch == quoteChar) {
                        attributeValue = new String(this.templateData, attributeValueStart, this.cursor - attributeValueStart);
                        if (attributeName.equalsIgnoreCase(jwcIdAttributeName)) {
                            jwcId = attributeValue;
                        } else {
                            this.attributes.put(attributeName, attributeValue);
                        }
                        if (attributeName.equalsIgnoreCase(LOCALIZATION_KEY_ATTRIBUTE_NAME)) {
                            localizationKey = attributeValue;
                        }
                        this.advance();
                        state = 0;
                        break;
                    }
                    this.advance();
                    break;
                }
                case 5: {
                    String attributeValue;
                    if (ch == '/' || ch == '>' || Character.isWhitespace(ch)) {
                        attributeValue = new String(this.templateData, attributeValueStart, this.cursor - attributeValueStart);
                        if (attributeName.equalsIgnoreCase(jwcIdAttributeName)) {
                            jwcId = attributeValue;
                        } else {
                            this.attributes.put(attributeName, attributeValue);
                        }
                        if (attributeName.equalsIgnoreCase(LOCALIZATION_KEY_ATTRIBUTE_NAME)) {
                            localizationKey = attributeValue;
                        }
                        state = 0;
                        break;
                    }
                    this.advance();
                }
            }
        }
        if (isJwcTag && jwcId == null) {
            throw new TemplateParseException(Tapestry.getString("TemplateParser.tag-missing-id", tagName, Integer.toString(startLine)), startLine, this.resourcePath);
        }
        if (tagName.equalsIgnoreCase("span") && localizationKey != null) {
            if (this.ignoring) {
                throw new TemplateParseException(Tapestry.getString("TemplateParser.component-may-not-be-ignored", tagName, Integer.toString(startLine)), startLine, this.resourcePath);
            }
            if (!emptyTag) {
                Tag tag = new Tag(tagName, startLine);
                tag.component = false;
                tag.removeTag = true;
                tag.ignoringBody = true;
                tag.mustBalance = true;
                this.stack.add(tag);
                this.ignoring = true;
            } else {
                this.advance();
                this.advanceOverWhitespace();
            }
            this.addTextToken(cursorStart - 1);
            TemplateToken token = new TemplateToken(TokenType.LOCALIZATION, localizationKey, tagName, this.filter(this.attributes, LOCALIZATION_KEY_ATTRIBUTE_NAME));
            this.tokens.add(token);
            return;
        }
        if (jwcId != null) {
            boolean ignoreBody;
            if (jwcId.equalsIgnoreCase(CONTENT_ID)) {
                if (this.ignoring) {
                    throw new TemplateParseException(Tapestry.getString("TemplateParser.content-block-may-not-be-ignored", tagName, Integer.toString(startLine)), startLine, this.resourcePath);
                }
                if (emptyTag) {
                    throw new TemplateParseException(Tapestry.getString("TemplateParser.content-block-may-not-be-empty", tagName, Integer.toString(startLine)), startLine, this.resourcePath);
                }
                this.tokens.clear();
                this.blockStart = -1;
                Tag tag = new Tag(tagName, startLine);
                tag.mustBalance = true;
                tag.content = true;
                this.stack.clear();
                this.stack.add(tag);
                this.advance();
                return;
            }
            boolean isRemoveId = jwcId.equalsIgnoreCase(REMOVE_ID);
            if (!isRemoveId && !this.delegate.getKnownComponent(jwcId)) {
                throw new TemplateParseException(Tapestry.getString("TemplateParser.unknown-component-id", tagName, Integer.toString(startLine), jwcId), startLine, this.resourcePath);
            }
            if (this.ignoring && !isRemoveId) {
                throw new TemplateParseException(Tapestry.getString("TemplateParser.component-may-not-be-ignored", tagName, Integer.toString(startLine)), startLine, this.resourcePath);
            }
            boolean bl = ignoreBody = !emptyTag && (isRemoveId || !this.delegate.getAllowBody(jwcId));
            if (this.ignoring && ignoreBody) {
                throw new TemplateParseException(Tapestry.getString("TemplateParser.nested-ignore", tagName, Integer.toString(startLine)), startLine, this.resourcePath);
            }
            if (!emptyTag) {
                Tag tag = new Tag(tagName, startLine);
                tag.component = !isRemoveId;
                tag.removeTag = isRemoveId;
                this.ignoring = tag.ignoringBody = ignoreBody;
                tag.mustBalance = true;
                this.stack.add(tag);
            }
            this.addTextToken(cursorStart - 1);
            if (!isRemoveId) {
                if (this.attributes.isEmpty()) {
                    this.tokens.add(new TemplateToken(jwcId, tagName));
                } else {
                    this.tokens.add(new TemplateToken(jwcId, tagName, new HashMap(this.attributes)));
                }
                if (emptyTag) {
                    this.tokens.add(new TemplateToken(TokenType.CLOSE, tagName));
                }
            }
            this.advance();
            return;
        }
        if (!emptyTag) {
            Tag tag = new Tag(tagName, startLine);
            this.stack.add(tag);
        }
        if (this.blockStart < 0 && !this.ignoring) {
            this.blockStart = cursorStart;
        }
        this.advance();
    }

    private void closeTag() throws TemplateParseException {
        int cursorStart = this.cursor;
        int length = this.templateData.length;
        int startLine = this.line;
        this.cursor += CLOSE_TAG.length;
        int tagStart = this.cursor;
        while (true) {
            if (this.cursor >= length) {
                throw new TemplateParseException(Tapestry.getString("TemplateParser.incomplete-close-tag", Integer.toString(startLine)), startLine, this.resourcePath);
            }
            char ch = this.templateData[this.cursor];
            if (ch == '>') break;
            this.advance();
        }
        String tagName = new String(this.templateData, tagStart, this.cursor - tagStart);
        int stackPos = this.stack.size() - 1;
        Tag tag = null;
        while (stackPos >= 0) {
            tag = (Tag)this.stack.get(stackPos);
            if (tag.match(tagName)) break;
            if (tag.mustBalance) {
                throw new TemplateParseException(Tapestry.getString("TemplateParser.improperly-nested-close-tag", new Object[]{tagName, Integer.toString(startLine), tag.tagName, Integer.toString(tag.line)}), startLine, this.resourcePath);
            }
            --stackPos;
        }
        if (stackPos < 0) {
            throw new TemplateParseException(Tapestry.getString("TemplateParser.unmatched-close-tag", tagName, Integer.toString(startLine)), startLine, this.resourcePath);
        }
        if (tag.content) {
            this.addTextToken(cursorStart - 1);
            this.cursor = length;
            this.stack.clear();
            return;
        }
        if (tag.component) {
            this.addTextToken(cursorStart - 1);
            this.tokens.add(new TemplateToken(TokenType.CLOSE, tagName));
        } else if (this.blockStart < 0 && !tag.removeTag && !this.ignoring) {
            this.blockStart = cursorStart;
        }
        int i = this.stack.size() - 1;
        while (i >= stackPos) {
            this.stack.remove(i);
            --i;
        }
        this.advance();
        if (tag.removeTag) {
            this.advanceOverWhitespace();
        }
        if (tag.ignoringBody) {
            this.ignoring = false;
        }
    }

    private void advance() {
        int length = this.templateData.length;
        if (this.cursor >= length) {
            return;
        }
        char ch = this.templateData[this.cursor];
        ++this.cursor;
        if (ch == '\n') {
            ++this.line;
            return;
        }
        if (ch == '\r') {
            ++this.line;
            if (this.cursor < length && this.templateData[this.cursor] == '\n') {
                ++this.cursor;
            }
            return;
        }
    }

    private void advanceOverWhitespace() {
        int length = this.templateData.length;
        while (this.cursor < length) {
            char ch = this.templateData[this.cursor];
            if (!Character.isWhitespace(ch)) {
                return;
            }
            this.advance();
        }
    }

    private Map filter(Map input, String removeKey) {
        if (input == null || input.isEmpty()) {
            return null;
        }
        HashMap result = null;
        Iterator i = input.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String key = (String)entry.getKey();
            if (key.equalsIgnoreCase(removeKey)) continue;
            if (result == null) {
                result = new HashMap(input.size());
            }
            result.put(key, entry.getValue());
        }
        return result;
    }

    private static class Tag {
        String tagName;
        boolean component;
        boolean ignoringBody;
        boolean removeTag;
        boolean mustBalance;
        int line;
        boolean content;

        Tag(String tagName, int line) {
            this.tagName = tagName;
            this.line = line;
        }

        boolean match(String matchTagName) {
            return this.tagName.equalsIgnoreCase(matchTagName);
        }
    }
}

