/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.parse;

import java.util.Iterator;
import java.util.Map;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IRender;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.parse.RenderTemplateHTML;
import net.sf.tapestry.parse.TokenType;

public class TemplateToken {
    private TokenType type;
    private String tag;
    private String id;
    char[] templateData;
    private int startIndex = -1;
    private int endIndex = -1;
    private IRender render;
    private Map attributes;

    public TemplateToken(char[] templateData, int startIndex, int endIndex) {
        this.type = TokenType.TEXT;
        this.templateData = templateData;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        if (startIndex < 0 || endIndex < 0 || startIndex > templateData.length || endIndex > templateData.length) {
            throw new IllegalArgumentException(Tapestry.getString("TemplateToken.range-error", this, Integer.toString(templateData.length)));
        }
    }

    public TemplateToken(TokenType type, String tag) {
        this(type, null, tag, null);
    }

    public TemplateToken(String id, String tag) {
        this(TokenType.OPEN, id, tag, null);
    }

    public TemplateToken(String id, String tag, Map attributes) {
        this(TokenType.OPEN, id, tag, attributes);
    }

    public TemplateToken(TokenType type, String id, String tag, Map attributes) {
        this.type = type;
        this.id = id;
        this.tag = tag;
        this.attributes = attributes;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public String getId() {
        return this.id;
    }

    public String getTag() {
        return this.tag;
    }

    public synchronized IRender getRender() {
        if (this.render == null) {
            if (this.type != TokenType.TEXT) {
                throw new ApplicationRuntimeException(Tapestry.getString("TemplateToken.may-not-render", this.type));
            }
            this.render = new RenderTemplateHTML(this.templateData, this.startIndex, this.endIndex - this.startIndex + 1);
        }
        return this.render;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public TokenType getType() {
        return this.type;
    }

    public Map getAttributes() {
        return this.attributes;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("TemplateToken[");
        buffer.append(this.type.getEnumerationId());
        if (this.id != null) {
            buffer.append(' ');
            buffer.append(this.id);
        }
        if (this.startIndex >= 0) {
            buffer.append(" start:");
            buffer.append(this.startIndex);
            buffer.append(" end:");
            buffer.append(this.endIndex);
        }
        boolean first = true;
        if (this.attributes != null) {
            Iterator i = this.attributes.keySet().iterator();
            while (i.hasNext()) {
                if (first) {
                    buffer.append(" attributes: ");
                    first = false;
                } else {
                    buffer.append(", ");
                }
                Map.Entry e = (Map.Entry)i.next();
                buffer.append(e.getKey());
                buffer.append('=');
                buffer.append(e.getValue());
            }
        }
        buffer.append(']');
        return buffer.toString();
    }
}

