/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.record;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IComponent;
import net.sf.tapestry.IPage;
import net.sf.tapestry.IPageRecorder;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.PageRecorderCommitException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.event.ObservedChangeEvent;
import net.sf.tapestry.record.PageChange;
import net.sf.tapestry.record.PageRecorderSerializationException;
import net.sf.tapestry.record.RollbackException;
import net.sf.tapestry.util.prop.OgnlUtils;
import ognl.ClassResolver;

public abstract class PageRecorder
implements IPageRecorder,
Serializable {
    protected transient boolean dirty = false;
    protected transient boolean locked = false;
    protected transient boolean discard = false;

    public abstract void commit() throws PageRecorderCommitException;

    public abstract Collection getChanges();

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean value) {
        this.locked = value;
    }

    public void observeChange(ObservedChangeEvent event) {
        IComponent component = event.getComponent();
        String propertyName = event.getPropertyName();
        if (this.locked) {
            throw new ApplicationRuntimeException(Tapestry.getString("PageRecorder.change-after-lock", component.getPage().getName(), propertyName, component.getExtendedId()));
        }
        if (propertyName == null) {
            this.dirty = true;
            return;
        }
        Serializable newValue = event.getNewValue();
        try {
            this.recordChange(component.getIdPath(), propertyName, newValue);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new ApplicationRuntimeException(Tapestry.getString("PageRecorder.unable-to-persist", propertyName, component.getExtendedId(), newValue), t);
        }
    }

    protected abstract void recordChange(String var1, String var2, Object var3);

    public void rollback(IPage page) {
        Collection changes = this.getChanges();
        if (changes.isEmpty()) {
            return;
        }
        IResourceResolver resolver = page.getEngine().getResourceResolver();
        Iterator i = changes.iterator();
        while (i.hasNext()) {
            PageChange change = (PageChange)i.next();
            IComponent component = page.getNestedComponent(change.componentPath);
            try {
                OgnlUtils.set(change.propertyName, (ClassResolver)resolver, (Object)component, change.newValue);
            }
            catch (Throwable t) {
                throw new RollbackException(component, change.propertyName, change.newValue, t);
            }
        }
    }

    protected Serializable persistValue(Object value) throws IOException {
        if (!(value instanceof EJBObject)) {
            try {
                return (Serializable)value;
            }
            catch (ClassCastException ex) {
                throw new PageRecorderSerializationException(ex);
            }
        }
        try {
            EJBObject ejb = (EJBObject)value;
            return ejb.getHandle();
        }
        catch (RemoteException ex) {
            throw new PageRecorderSerializationException(ex);
        }
    }

    protected Object restoreValue(Object value) throws IOException {
        if (!(value instanceof Handle)) {
            return value;
        }
        try {
            Handle handle = (Handle)value;
            return handle.getEJBObject();
        }
        catch (RemoteException ex) {
            throw new PageRecorderSerializationException(ex);
        }
    }

    public boolean isMarkedForDiscard() {
        return this.discard;
    }

    public void markForDiscard() {
        this.discard = true;
    }

    public abstract boolean getHasChanges();
}

