/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.script;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IResourceResolver;
import net.sf.tapestry.IScript;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.script.BodyToken;
import net.sf.tapestry.script.ForeachToken;
import net.sf.tapestry.script.IScriptToken;
import net.sf.tapestry.script.IfToken;
import net.sf.tapestry.script.IncludeScriptToken;
import net.sf.tapestry.script.InitToken;
import net.sf.tapestry.script.InputSymbolToken;
import net.sf.tapestry.script.InsertToken;
import net.sf.tapestry.script.LetToken;
import net.sf.tapestry.script.ParsedScript;
import net.sf.tapestry.script.SetToken;
import net.sf.tapestry.script.StaticToken;
import net.sf.tapestry.util.xml.AbstractDocumentParser;
import net.sf.tapestry.util.xml.DocumentParseException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ScriptParser
extends AbstractDocumentParser {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$script$ScriptParser == null ? (class$net$sf$tapestry$script$ScriptParser = ScriptParser.class$("net.sf.tapestry.script.ScriptParser")) : class$net$sf$tapestry$script$ScriptParser));
    private static final int MAP_SIZE = 11;
    private Map _insertCache;
    private IResourceResolver _resolver;
    private boolean _version_1_2;
    private String _expressionAttribute;
    public static final String SCRIPT_DTD_1_0_PUBLIC_ID = "-//Primix Solutions//Tapestry Script 1.0//EN";
    public static final String SCRIPT_DTD_1_1_PUBLIC_ID = "-//Howard Ship//Tapestry Script 1.1//EN";
    public static final String SCRIPT_DTD_1_2_PUBLIC_ID = "-//Howard Lewis Ship//Tapestry Script 1.2//EN";
    private static final int STATE_START = 0;
    private static final int STATE_DOLLAR = 1;
    private static final int STATE_COLLECT_EXPRESSION = 2;
    static /* synthetic */ Class class$net$sf$tapestry$script$ScriptParser;

    public ScriptParser(IResourceResolver resolver) {
        this._resolver = resolver;
        this.register(SCRIPT_DTD_1_0_PUBLIC_ID, "Script_1_0.dtd");
        this.register(SCRIPT_DTD_1_1_PUBLIC_ID, "Script_1_1.dtd");
        this.register(SCRIPT_DTD_1_2_PUBLIC_ID, "Script_1_2.dtd");
    }

    public IScript parse(InputStream stream, String resourcePath) throws DocumentParseException {
        InputSource source = new InputSource(stream);
        try {
            Document document = this.parse(source, resourcePath, "script");
            IScript iScript = this.build(document);
            Object var7_6 = null;
            this.setResourcePath(null);
            return iScript;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.setResourcePath(null);
            throw throwable;
        }
    }

    private IScript build(Document document) throws DocumentParseException {
        ParsedScript result = new ParsedScript(this.getResourcePath());
        Element root = document.getDocumentElement();
        String publicId = document.getDoctype().getPublicId();
        if (!(publicId.equals(SCRIPT_DTD_1_0_PUBLIC_ID) || publicId.equals(SCRIPT_DTD_1_1_PUBLIC_ID) || publicId.equals(SCRIPT_DTD_1_2_PUBLIC_ID))) {
            throw new DocumentParseException(Tapestry.getString("ScriptParser.unknown-public-id", publicId), this.getResourcePath());
        }
        this._version_1_2 = publicId.equals(SCRIPT_DTD_1_2_PUBLIC_ID);
        this._expressionAttribute = this._version_1_2 ? "expression" : "property-path";
        Node child = root.getFirstChild();
        while (child != null) {
            if (this.isElement(child, "let")) {
                result.addToken(this.buildLet(child));
            } else if (this.isElement(child, "set")) {
                result.addToken(this.buildSet(child));
            } else if (this.isElement(child, "include-script")) {
                result.addToken(this.buildIncludeScript(child));
            } else if (this.isElement(child, "input-symbol")) {
                result.addToken(this.buildInputSymbol(child));
            } else if (this.isElement(child, "body")) {
                result.addToken(this.buildBody(child));
            } else if (this.isElement(child, "initialization")) {
                result.addToken(this.buildInitialization(child));
            }
            child = child.getNextSibling();
        }
        return result;
    }

    private IScriptToken buildLet(Node node) throws DocumentParseException {
        String key = this.getAttribute(node, "key");
        this.validate(key, "^_?[a-zA-Z]\\w*$", "ScriptParser.invalid-key");
        LetToken token = new LetToken(key);
        this.build(token, node);
        return token;
    }

    public IScriptToken buildSet(Node node) throws DocumentParseException {
        String key = this.getAttribute(node, "key");
        this.validate(key, "^_?[a-zA-Z]\\w*$", "ScriptParser.invalid-key");
        String expression = this.getAttribute(node, "expression");
        return new SetToken(key, expression, this._resolver);
    }

    private IScriptToken buildInputSymbol(Node node) throws DocumentParseException {
        String key = this.getAttribute(node, "key");
        this.validate(key, "^_?[a-zA-Z]\\w*$", "ScriptParser.invalid-key");
        String className = this.getAttribute(node, "class");
        Class expectedClass = this.lookupClass(className);
        String required = this.getAttribute(node, "required");
        return new InputSymbolToken(key, expectedClass, required.equals("yes"));
    }

    private Class lookupClass(String className) throws DocumentParseException {
        if (Tapestry.isNull(className)) {
            return null;
        }
        try {
            return this._resolver.findClass(className);
        }
        catch (ApplicationRuntimeException ex) {
            throw new DocumentParseException(Tapestry.getString("ScriptParser.unable-to-resolve-class", className), this.getResourcePath(), ex);
        }
    }

    private IScriptToken buildBody(Node node) throws DocumentParseException {
        BodyToken token = new BodyToken();
        this.build(token, node);
        return token;
    }

    private IScriptToken buildInitialization(Node node) throws DocumentParseException {
        InitToken token = new InitToken();
        this.build(token, node);
        return token;
    }

    private void build(IScriptToken token, Node node) throws DocumentParseException {
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() != 8) {
                if (this.isElement(child, "insert")) {
                    token.addToken(this.buildInsert(child));
                } else if (this.isElement(child, "if")) {
                    token.addToken(this.buildIf(true, child));
                } else if (this.isElement(child, "if-not")) {
                    token.addToken(this.buildIf(false, child));
                } else if (this.isElement(child, "foreach")) {
                    token.addToken(this.buildForeach(child));
                } else {
                    CharacterData textNode = (CharacterData)child;
                    String staticText = textNode.getData();
                    this.addTextTokens(token, staticText);
                }
            }
            child = child.getNextSibling();
        }
    }

    private IScriptToken buildInsert(Node node) {
        String expression = this.getAttribute(node, this._expressionAttribute);
        if (expression == null) {
            expression = this.getAttribute(node, "key");
        }
        return this.constructInsert(expression);
    }

    private IScriptToken constructInsert(String expression) {
        IScriptToken result = null;
        if (this._insertCache == null) {
            this._insertCache = new HashMap(11);
        } else {
            result = (IScriptToken)this._insertCache.get(expression);
        }
        if (result == null) {
            result = new InsertToken(expression, this._resolver);
            this._insertCache.put(expression, result);
        }
        return result;
    }

    private IScriptToken buildIf(boolean condition, Node node) throws DocumentParseException {
        String expression = this.getAttribute(node, this._expressionAttribute);
        IfToken result = new IfToken(condition, expression, this._resolver);
        this.build(result, node);
        return result;
    }

    private IScriptToken buildForeach(Node node) throws DocumentParseException {
        String key = this.getAttribute(node, "key");
        String expression = this.getAttribute(node, this._expressionAttribute);
        ForeachToken result = new ForeachToken(key, expression, this._resolver);
        this.build(result, node);
        return result;
    }

    private IScriptToken buildIncludeScript(Node node) {
        String path = this.getAttribute(node, "resource-path");
        return new IncludeScriptToken(path);
    }

    private void addTextTokens(IScriptToken token, String text) {
        char[] buffer = text.toCharArray();
        int state = 0;
        int blockStart = 0;
        int blockLength = 0;
        int expressionStart = -1;
        int expressionLength = 0;
        int i = 0;
        int braceDepth = 0;
        while (i < buffer.length) {
            char ch = buffer[i];
            switch (state) {
                case 0: {
                    if (ch == '$') {
                        state = 1;
                        ++i;
                        break;
                    }
                    ++blockLength;
                    ++i;
                    break;
                }
                case 1: {
                    if (ch == '{') {
                        state = 2;
                        expressionStart = ++i;
                        expressionLength = 0;
                        braceDepth = 1;
                        break;
                    }
                    state = 0;
                    break;
                }
                case 2: {
                    if (ch != '}') {
                        if (ch == '{') {
                            ++braceDepth;
                        }
                        ++i;
                        ++expressionLength;
                        break;
                    }
                    if (--braceDepth > 0) {
                        ++i;
                        ++expressionLength;
                        break;
                    }
                    if (expressionLength == 0) {
                        blockLength += 3;
                    }
                    if (blockLength > 0) {
                        token.addToken(this.constructStatic(text, blockStart, blockLength));
                    }
                    if (expressionLength > 0) {
                        String expression = text.substring(expressionStart, expressionStart + expressionLength);
                        token.addToken(this.constructInsert(expression));
                    }
                    blockStart = ++i;
                    blockLength = 0;
                    state = 0;
                    break;
                }
            }
        }
        if (state == 1) {
            ++blockLength;
        }
        if (state == 2) {
            blockLength += expressionLength + 2;
        }
        if (blockLength > 0) {
            token.addToken(this.constructStatic(text, blockStart, blockLength));
        }
    }

    private IScriptToken constructStatic(String text, int blockStart, int blockLength) {
        return new StaticToken(text.substring(blockStart, blockStart + blockLength));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

