/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sf.tapestry.Tapestry;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class AdaptorRegistry {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$util$AdaptorRegistry == null ? (class$net$sf$tapestry$util$AdaptorRegistry = AdaptorRegistry.class$("net.sf.tapestry.util.AdaptorRegistry")) : class$net$sf$tapestry$util$AdaptorRegistry));
    private Map registrations = new HashMap();
    private Map cache = new HashMap();
    static /* synthetic */ Class class$net$sf$tapestry$util$AdaptorRegistry;
    static /* synthetic */ Class class$java$lang$Object;

    public void register(Class registrationClass, Object adaptor) {
        Map map = this.registrations;
        synchronized (map) {
            if (this.registrations.containsKey(registrationClass)) {
                throw new IllegalArgumentException(Tapestry.getString("AdaptorRegistry.duplicate-registration", registrationClass.getName()));
            }
            this.registrations.put(registrationClass, adaptor);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Registered " + adaptor + " for " + registrationClass.getName()));
        }
        Map map2 = this.cache;
        synchronized (map2) {
            this.cache.clear();
        }
    }

    public Object getAdaptor(Class subjectClass) {
        Object result;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting adaptor for class " + subjectClass.getName()));
        }
        Map map = this.cache;
        synchronized (map) {
            result = this.cache.get(subjectClass);
            if (result != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found " + result + " in cache"));
                }
                Object v = result;
                return v;
            }
        }
        result = this.searchForAdaptor(subjectClass);
        Map map2 = this.cache;
        synchronized (map2) {
            this.cache.put(subjectClass, result);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found " + result));
        }
        return result;
    }

    private Object searchForAdaptor(Class subjectClass) {
        LinkedList queue = null;
        if (this.registrations == null) {
            throw new IllegalArgumentException("No adaptors have been registered.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Searching for adaptor for class " + subjectClass.getName()));
        }
        Map map = this.registrations;
        synchronized (map) {
            int i;
            int length;
            Class<?>[] interfaces;
            Object result;
            Class searchClass = subjectClass;
            while (searchClass != (class$java$lang$Object == null ? AdaptorRegistry.class$("java.lang.Object") : class$java$lang$Object) && searchClass != null) {
                result = this.registrations.get(searchClass);
                if (result != null) {
                    Object v = result;
                    return v;
                }
                interfaces = searchClass.getInterfaces();
                length = interfaces.length;
                if (queue == null && length > 0) {
                    queue = new LinkedList();
                }
                i = 0;
                while (i < length) {
                    queue.addLast(interfaces[i]);
                    ++i;
                }
                searchClass = searchClass.getSuperclass();
            }
            if (queue != null) {
                while (!queue.isEmpty()) {
                    searchClass = (Class)queue.removeFirst();
                    result = this.registrations.get(searchClass);
                    if (result != null) {
                        Object v = result;
                        return v;
                    }
                    interfaces = searchClass.getInterfaces();
                    length = interfaces.length;
                    i = 0;
                    while (i < length) {
                        queue.addLast(interfaces[i]);
                        ++i;
                    }
                }
            }
            if ((result = this.registrations.get(class$java$lang$Object == null ? (class$java$lang$Object = AdaptorRegistry.class$("java.lang.Object")) : class$java$lang$Object)) != null) {
                Object v = result;
                return v;
            }
        }
        throw new IllegalArgumentException(Tapestry.getString("AdaptorRegistry.adaptor-not-found", subjectClass.getName()));
    }

    public String toString() {
        boolean first = true;
        StringBuffer buffer = new StringBuffer();
        buffer.append("AdaptorRegistry[");
        if (this.registrations != null) {
            Map map = this.registrations;
            synchronized (map) {
                Iterator i = this.registrations.entrySet().iterator();
                while (i.hasNext()) {
                    if (!first) {
                        buffer.append(' ');
                    }
                    Map.Entry entry = i.next();
                    Class registeredClass = (Class)entry.getKey();
                    buffer.append(registeredClass.getName());
                    buffer.append("=");
                    buffer.append(entry.getValue());
                    first = false;
                }
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

