/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.util.pool;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRenderDescription;
import net.sf.tapestry.util.ICleanable;
import net.sf.tapestry.util.JanitorThread;
import net.sf.tapestry.util.pool.IPoolable;
import net.sf.tapestry.util.pool.PoolList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Pool
implements ICleanable,
IRenderDescription {
    private static final Logger LOG = LogManager.getLogger((Class)(class$net$sf$tapestry$util$pool$Pool == null ? (class$net$sf$tapestry$util$pool$Pool = Pool.class$("net.sf.tapestry.util.pool.Pool")) : class$net$sf$tapestry$util$pool$Pool));
    private int generation;
    private int window = 10;
    private int pooledCount;
    private Map map;
    static /* synthetic */ Class class$net$sf$tapestry$util$pool$Pool;

    public Pool() {
        this(true);
    }

    public Pool(int mapSize) {
        this(mapSize, true);
    }

    public Pool(boolean useSharedJanitor) {
        if (useSharedJanitor) {
            JanitorThread.getSharedJanitorThread().add(this);
        }
    }

    public Pool(int mapSize, boolean useSharedJanitor) {
        this(useSharedJanitor);
        this.map = new HashMap(mapSize);
    }

    public int getWindow() {
        return this.window;
    }

    public void setWindow(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("Pool window may not be less than 1.");
        }
        this.window = value;
    }

    public synchronized Object retrieve(Object key) {
        PoolList list;
        Object result = null;
        if (this.map == null) {
            this.map = new HashMap();
        }
        if ((list = (PoolList)this.map.get(key)) != null) {
            result = list.retrieve();
        }
        if (result != null) {
            --this.pooledCount;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieved " + result + " from " + key));
        }
        return result;
    }

    public synchronized void store(Object key, Object object) {
        PoolList list;
        if (object instanceof IPoolable) {
            ((IPoolable)object).resetForPool();
        }
        if (this.map == null) {
            this.map = new HashMap();
        }
        if ((list = (PoolList)this.map.get(key)) == null) {
            list = new PoolList();
            this.map.put(key, list);
        }
        int count = list.store(this.generation, object);
        ++this.pooledCount;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Stored " + object + " into " + key + " (" + count + " pooled)"));
        }
    }

    public synchronized void clear() {
        if (this.map != null) {
            this.map.clear();
        }
        this.pooledCount = 0;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Cleared");
        }
    }

    public int getPooledCount() {
        return this.pooledCount;
    }

    public synchronized int getKeyCount() {
        if (this.map == null) {
            return 0;
        }
        return this.map.size();
    }

    public synchronized void executeCleanup() {
        if (this.map == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing cleanup of " + this));
        }
        ++this.generation;
        int oldestGeneration = this.generation - this.window;
        if (oldestGeneration < 0) {
            return;
        }
        int oldCount = this.pooledCount;
        int culledKeys = 0;
        int newCount = 0;
        Iterator i = this.map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            PoolList list = (PoolList)e.getValue();
            int count = list.cleanup(oldestGeneration);
            if (count == 0) {
                i.remove();
                ++culledKeys;
                continue;
            }
            newCount += count;
        }
        this.pooledCount = newCount;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Culled " + (oldCount - this.pooledCount) + " pooled objects and " + culledKeys + " keys."));
        }
    }

    public String toString() {
        if (this.map == null) {
            return super.toString();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Pool@");
        buffer.append(Integer.toHexString(this.hashCode()));
        buffer.append("[Generation ");
        buffer.append(this.generation);
        if (this.pooledCount > 0) {
            buffer.append(", ");
            buffer.append(this.pooledCount);
            buffer.append(" pooled");
        }
        Pool pool = this;
        synchronized (pool) {
            Iterator i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                PoolList list = (PoolList)entry.getValue();
                buffer.append(", ");
                buffer.append(entry.getKey());
                buffer.append('=');
                buffer.append(list.getPooledCount());
            }
        }
        buffer.append(']');
        return buffer.toString();
    }

    public void renderDescription(IMarkupWriter writer) {
        writer.print("Pool[Generation = ");
        writer.print(this.generation);
        writer.print(" Pooled = ");
        writer.print(this.pooledCount);
        writer.print("]");
        if (this.map == null) {
            return;
        }
        boolean first = true;
        Pool pool = this;
        synchronized (pool) {
            Iterator i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                PoolList list = (PoolList)entry.getValue();
                if (first) {
                    writer.begin("ul");
                    first = false;
                }
                writer.begin("li");
                writer.print(entry.getKey().toString());
                writer.print(" = ");
                writer.print(list.getPooledCount());
                writer.println();
                writer.end();
            }
        }
        if (!first) {
            writer.end();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

