/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.util.pool;

class PoolList {
    private Entry first;
    private Entry spare;
    private int count;

    PoolList() {
    }

    public int getPooledCount() {
        return this.count;
    }

    public Object retrieve() {
        if (this.count == 0) {
            return null;
        }
        --this.count;
        Entry e = this.first;
        Object result = e.pooled;
        this.first = e.next;
        e.next = this.spare;
        this.spare = e;
        e.generation = 0;
        e.pooled = null;
        return result;
    }

    public int store(int generation, Object object) {
        Entry e;
        if (this.spare == null) {
            e = new Entry();
        } else {
            e = this.spare;
            this.spare = this.spare.next;
        }
        e.generation = generation;
        e.pooled = object;
        e.next = this.first;
        this.first = e;
        return ++this.count;
    }

    public int cleanup(int generation) {
        this.spare = null;
        this.count = 0;
        Entry prev = null;
        Entry e = this.first;
        while (e != null) {
            if (e.generation <= generation) {
                if (prev == null) {
                    this.first = null;
                    break;
                }
                prev.next = null;
                break;
            }
            prev = e;
            e = e.next;
            ++this.count;
        }
        return this.count;
    }

    public String toString() {
        return "PoolList[" + this.count + "]";
    }

    private static class Entry {
        int generation;
        Object pooled;
        Entry next;

        private Entry() {
        }
    }
}

