/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.util.prop;

import java.util.HashMap;
import java.util.Map;
import net.sf.tapestry.ApplicationRuntimeException;
import ognl.ClassResolver;
import ognl.Ognl;
import ognl.OgnlException;

public class OgnlUtils {
    private static final Map _cache = new HashMap();

    private OgnlUtils() {
    }

    public static synchronized Object getParsedExpression(String expression) {
        Object result = _cache.get(expression);
        if (result == null) {
            try {
                result = Ognl.parseExpression((String)expression);
            }
            catch (OgnlException ex) {
                throw new ApplicationRuntimeException(ex);
            }
            _cache.put(expression, result);
        }
        return result;
    }

    public static void set(String expression, ClassResolver resolver, Object target, Object value) {
        OgnlUtils.set(OgnlUtils.getParsedExpression(expression), resolver, target, value);
    }

    public static void set(Object expression, ClassResolver resolver, Object target, Object value) {
        try {
            Map context = Ognl.createDefaultContext((Object)target, (ClassResolver)resolver);
            Ognl.setValue((Object)expression, (Map)context, (Object)target, (Object)value);
        }
        catch (OgnlException ex) {
            throw new ApplicationRuntimeException(ex);
        }
    }

    public static Object get(Object expression, ClassResolver resolver, Object object) {
        try {
            Map context = Ognl.createDefaultContext((Object)object, (ClassResolver)resolver);
            return Ognl.getValue((Object)expression, (Map)context, (Object)object);
        }
        catch (OgnlException ex) {
            throw new ApplicationRuntimeException(ex);
        }
    }

    public static Object get(String expression, ClassResolver resolver, Object object) {
        return OgnlUtils.get(OgnlUtils.getParsedExpression(expression), resolver, object);
    }
}

