/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.util.xml;

import org.xml.sax.SAXParseException;

public class DocumentParseException
extends Exception {
    private Throwable rootCause;
    private int lineNumber;
    private int column;
    private String resourcePath;

    public DocumentParseException(String message, Throwable rootCause) {
        this(message, null, rootCause);
    }

    public DocumentParseException(String message, String resourcePath) {
        this(message, resourcePath, null);
    }

    public DocumentParseException(String message, SAXParseException rootCause) {
        this(message, null, rootCause);
    }

    public DocumentParseException(String message, String resourcePath, Throwable rootCause) {
        super(message);
        this.resourcePath = resourcePath;
        this.rootCause = rootCause;
    }

    public DocumentParseException(String message, String resourcePath, SAXParseException rootCause) {
        this(message, resourcePath, (Throwable)rootCause);
        if (rootCause != null) {
            this.lineNumber = rootCause.getLineNumber();
            this.column = rootCause.getColumnNumber();
        }
    }

    public DocumentParseException(String message) {
        super(message);
    }

    public DocumentParseException(Throwable rootCause) {
        this(rootCause.getMessage(), rootCause);
    }

    public DocumentParseException(SAXParseException rootCause) {
        this(rootCause.getMessage(), (Throwable)rootCause);
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumn() {
        return this.column;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }
}

