/*
 * Decompiled with CFR 0.152.
 */
package net.sf.tapestry.valid;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Locale;
import net.sf.tapestry.ApplicationRuntimeException;
import net.sf.tapestry.IMarkupWriter;
import net.sf.tapestry.IRequestCycle;
import net.sf.tapestry.RequestCycleException;
import net.sf.tapestry.Tapestry;
import net.sf.tapestry.util.AdaptorRegistry;
import net.sf.tapestry.valid.BaseValidator;
import net.sf.tapestry.valid.IField;
import net.sf.tapestry.valid.ValidationConstraint;
import net.sf.tapestry.valid.ValidatorException;

public class NumberValidator
extends BaseValidator {
    private boolean _zeroIsNull;
    private Number _minimum;
    private Number _maximum;
    private String _scriptPath = "/net/sf/tapestry/valid/NumberValidator.script";
    private static AdaptorRegistry _numberAdaptors = new AdaptorRegistry();
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    public String toString(IField field, Object value) {
        Number number;
        if (value == null) {
            return null;
        }
        if (this._zeroIsNull && (number = (Number)value).doubleValue() == 0.0) {
            return null;
        }
        return value.toString();
    }

    private NumberAdaptor getAdaptor(IField field) {
        Class valueType = field.getValueType();
        NumberAdaptor result = (NumberAdaptor)_numberAdaptors.getAdaptor(valueType);
        if (result == null) {
            throw new ApplicationRuntimeException(Tapestry.getString("NumberValidator.no-adaptor-for-field", field, valueType.getName()));
        }
        return result;
    }

    public Object toObject(IField field, String value) throws ValidatorException {
        if (this.checkRequired(field, value)) {
            return null;
        }
        NumberAdaptor adaptor = this.getAdaptor(field);
        Number result = null;
        try {
            result = adaptor.parse(value);
        }
        catch (NumberFormatException ex) {
            String errorMessage = this.getString("invalid-numeric-format", field.getPage().getLocale(), field.getDisplayName());
            throw new ValidatorException(errorMessage, ValidationConstraint.NUMBER_FORMAT, value);
        }
        if (this._minimum != null && adaptor.compare(result, this._minimum) < 0) {
            String errorMessage = this.getString("number-too-small", field.getPage().getLocale(), field.getDisplayName(), this._minimum);
            throw new ValidatorException(errorMessage, ValidationConstraint.TOO_SMALL, value);
        }
        if (this._maximum != null && adaptor.compare(result, this._maximum) > 0) {
            String errorMessage = this.getString("number-too-large", field.getPage().getLocale(), field.getDisplayName(), this._maximum);
            throw new ValidatorException(errorMessage, ValidationConstraint.TOO_LARGE, value);
        }
        return result;
    }

    public Number getMaximum() {
        return this._maximum;
    }

    public boolean getHasMaximum() {
        return this._maximum != null;
    }

    public void setMaximum(Number maximum) {
        this._maximum = maximum;
    }

    public Number getMinimum() {
        return this._minimum;
    }

    public boolean getHasMinimum() {
        return this._minimum != null;
    }

    public void setMinimum(Number minimum) {
        this._minimum = minimum;
    }

    public boolean getZeroIsNull() {
        return this._zeroIsNull;
    }

    public void setZeroIsNull(boolean zeroIsNull) {
        this._zeroIsNull = zeroIsNull;
    }

    public void renderValidatorContribution(IField field, IMarkupWriter writer, IRequestCycle cycle) throws RequestCycleException {
        if (!this.isClientScriptingEnabled()) {
            return;
        }
        if (!this.isRequired() && this._minimum == null && this._maximum == null) {
            return;
        }
        HashMap<String, String> symbols = new HashMap<String, String>();
        Locale locale = field.getPage().getLocale();
        String displayName = field.getDisplayName();
        if (this.isRequired()) {
            symbols.put("requiredMessage", this.getString("field-is-required", locale, displayName));
        }
        NumberAdaptor adaptor = this.getAdaptor(field);
        symbols.put("formatMessage", this.getString("invalid-numeric-format", locale, displayName));
        if (this._minimum != null || this._maximum != null) {
            symbols.put("rangeMessage", this.buildRangeMessage(displayName, locale));
        }
        this.processValidatorScript(this._scriptPath, cycle, field, symbols);
    }

    private String buildRangeMessage(String displayName, Locale locale) {
        if (this._minimum != null && this._maximum != null) {
            return this.getString("number-range", locale, new Object[]{displayName, this._minimum, this._maximum});
        }
        if (this._minimum != null) {
            return this.getString("number-too-small", locale, displayName, this._minimum);
        }
        return this.getString("number-too-large", locale, displayName, this._maximum);
    }

    public String getScriptPath() {
        return this._scriptPath;
    }

    public void setScriptPath(String scriptPath) {
        this._scriptPath = scriptPath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ByteAdaptor byteAdaptor = new ByteAdaptor();
        ShortAdaptor shortAdaptor = new ShortAdaptor();
        IntAdaptor intAdaptor = new IntAdaptor();
        LongAdaptor longAdaptor = new LongAdaptor();
        FloatAdaptor floatAdaptor = new FloatAdaptor();
        DoubleAdaptor doubleAdaptor = new DoubleAdaptor();
        _numberAdaptors.register(class$java$lang$Byte == null ? (class$java$lang$Byte = NumberValidator.class$("java.lang.Byte")) : class$java$lang$Byte, byteAdaptor);
        _numberAdaptors.register(Byte.TYPE, byteAdaptor);
        _numberAdaptors.register(class$java$lang$Short == null ? (class$java$lang$Short = NumberValidator.class$("java.lang.Short")) : class$java$lang$Short, shortAdaptor);
        _numberAdaptors.register(Short.TYPE, shortAdaptor);
        _numberAdaptors.register(class$java$lang$Integer == null ? (class$java$lang$Integer = NumberValidator.class$("java.lang.Integer")) : class$java$lang$Integer, intAdaptor);
        _numberAdaptors.register(Integer.TYPE, intAdaptor);
        _numberAdaptors.register(class$java$lang$Long == null ? (class$java$lang$Long = NumberValidator.class$("java.lang.Long")) : class$java$lang$Long, longAdaptor);
        _numberAdaptors.register(Long.TYPE, longAdaptor);
        _numberAdaptors.register(class$java$lang$Float == null ? (class$java$lang$Float = NumberValidator.class$("java.lang.Float")) : class$java$lang$Float, floatAdaptor);
        _numberAdaptors.register(Float.TYPE, floatAdaptor);
        _numberAdaptors.register(class$java$lang$Double == null ? (class$java$lang$Double = NumberValidator.class$("java.lang.Double")) : class$java$lang$Double, doubleAdaptor);
        _numberAdaptors.register(Double.TYPE, doubleAdaptor);
        _numberAdaptors.register(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = NumberValidator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new BigDecimalAdaptor());
        _numberAdaptors.register(class$java$math$BigInteger == null ? (class$java$math$BigInteger = NumberValidator.class$("java.math.BigInteger")) : class$java$math$BigInteger, new BigIntegerAdaptor());
    }

    private static class BigIntegerAdaptor
    extends NumberAdaptor {
        private BigIntegerAdaptor() {
        }

        public Number parse(String value) {
            return new BigInteger(value);
        }
    }

    private static class BigDecimalAdaptor
    extends FloatAdaptor {
        private BigDecimalAdaptor() {
        }

        public Number parse(String value) {
            return new BigDecimal(value);
        }
    }

    private static class DoubleAdaptor
    extends FloatAdaptor {
        private DoubleAdaptor() {
        }

        public Number parse(String value) {
            return new Double(value);
        }
    }

    private static class FloatAdaptor
    extends NumberAdaptor {
        private FloatAdaptor() {
        }

        public Number parse(String value) {
            return new Float(value);
        }
    }

    private static class LongAdaptor
    extends NumberAdaptor {
        private LongAdaptor() {
        }

        public Number parse(String value) {
            return new Long(value);
        }
    }

    private static class IntAdaptor
    extends NumberAdaptor {
        private IntAdaptor() {
        }

        public Number parse(String value) {
            return new Integer(value);
        }
    }

    private static class ShortAdaptor
    extends NumberAdaptor {
        private ShortAdaptor() {
        }

        public Number parse(String value) {
            return new Short(value);
        }
    }

    private static class ByteAdaptor
    extends NumberAdaptor {
        private ByteAdaptor() {
        }

        public Number parse(String value) {
            return new Byte(value);
        }
    }

    private static abstract class NumberAdaptor {
        private NumberAdaptor() {
        }

        public abstract Number parse(String var1);

        public int compare(Number left, Number right) {
            Comparable lc = (Comparable)((Object)left);
            return lc.compareTo(right);
        }
    }
}

