/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import team.bangbang.common.config.Config;
import team.bangbang.common.data.KeyValue;
import team.bangbang.common.data.generator.Sequence;
import team.bangbang.common.exception.BizException;
import team.bangbang.common.file.FileReader;
import team.bangbang.common.file.FileWriter;
import team.bangbang.common.log.Logger;
import team.bangbang.common.sql.SQLPool;
import team.bangbang.common.utility.LogicUtility;

public final class CommonMPI {
    private static Logger log = Logger.getInstance(CommonMPI.class);
    private static Sequence sequenceInstance = null;
    private static final String[] sexFlags = new String[]{"\u7537", "\u5973"};
    public static final String ISNULL;
    public static final String NOW;
    private static String CONSOLE_ROOT;

    public static List<KeyValue> getSexList() {
        return CommonMPI.getDictionaryList(sexFlags);
    }

    public static String getSexName(Integer sexFlag) {
        return CommonMPI.getDictionaryName(sexFlags, sexFlag);
    }

    public static List<KeyValue> getBooleanList() {
        ArrayList<KeyValue> lst = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(new Boolean(true), "\u662f");
        lst.add(kv1);
        KeyValue kv2 = new KeyValue(new Boolean(false), "\u5426");
        lst.add(kv2);
        return lst;
    }

    public static List<KeyValue> getActiveList() {
        ArrayList<KeyValue> lst = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(new Boolean(true), "\u6709\u6548");
        lst.add(kv1);
        KeyValue kv2 = new KeyValue(new Boolean(false), "\u65e0\u6548");
        lst.add(kv2);
        return lst;
    }

    public static List<KeyValue> getDictionaryList(String[] arr) {
        ArrayList<KeyValue> lst = new ArrayList<KeyValue>();
        for (int i = 0; arr != null && i < arr.length; ++i) {
            KeyValue kv = new KeyValue(new Integer(i + 1), arr[i]);
            lst.add(kv);
        }
        return lst;
    }

    public static String getDictionaryName(String[] arr, Integer flag) {
        int nIndex;
        if (arr == null) {
            return null;
        }
        int n = nIndex = flag == null ? 0 : flag;
        if (--nIndex < 0 || nIndex >= arr.length) {
            return null;
        }
        return arr[nIndex];
    }

    public static void writeAttachFile(String tableName, Date dt, String pkValue, byte[] content) throws IOException {
        File f;
        String menu = Config.getProperty("file.attachment.directory");
        if (menu == null) {
            throw new IOException("\u4e3a\u4e86\u5b58\u653e\u8bb0\u5f55\u5173\u8054\u6587\u4ef6\uff0c\u8bf7\u5728application.properties\u6587\u4ef6\u4e2d\u914d\u7f6e{file.attachment.directory}\u76ee\u5f55\uff01");
        }
        String dir = menu + "/" + tableName + "/";
        if (dt != null) {
            dir = dir + LogicUtility.getYearMonth(dt) + "/";
        }
        if (!(f = new File(dir)).exists()) {
            f.mkdirs();
        }
        FileWriter fw = new FileWriter(dir + pkValue + ".dat");
        fw.writeBytes(content);
    }

    public static byte[] readAttachFile(String tableName, Date dt, String pkValue) throws IOException {
        File f;
        String menu = Config.getProperty("file.attachment.directory");
        if (menu == null) {
            throw new IOException("\u5728application.properties\u6587\u4ef6\u4e2d\u6ca1\u6709\u914d\u7f6e{file.attachment.directory}\u76ee\u5f55\uff01");
        }
        String file = menu + "/" + tableName + "/";
        if (dt != null) {
            file = file + LogicUtility.getYearMonth(dt) + "/";
        }
        if (!(f = new File(file = file + pkValue + ".dat")).exists()) {
            return null;
        }
        byte[] by = null;
        FileReader reader = new FileReader(file);
        by = reader.readBytes();
        return by;
    }

    public static boolean deleteAttachFile(String tableName, Date dt, String pkValue) throws IOException {
        File f;
        String menu = Config.getProperty("file.attachment.directory");
        if (menu == null) {
            throw new IOException("\u5728application.properties\u6587\u4ef6\u4e2d\u6ca1\u6709\u914d\u7f6e{file.attachment.directory}\u76ee\u5f55\uff01");
        }
        String file = menu + "/" + tableName + "/";
        if (dt != null) {
            file = file + LogicUtility.getYearMonth(dt) + "/";
        }
        if (!(f = new File(file = file + pkValue + ".dat")).exists()) {
            return false;
        }
        f = new File(file);
        return f.delete();
    }

    public static String getRandomString(int length) {
        String codeSerial = "123456789abcdefghkmnpqrstwxyABCDEFGHKLMNPQRSTWXY";
        Random random = new Random();
        int n = codeSerial.length();
        StringBuffer code = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            code.append(codeSerial.charAt(random.nextInt(n)));
        }
        return code.toString();
    }

    public static String getRandomNumber(int length) {
        String serial = "0123456789";
        Random random = new Random();
        int n = serial.length();
        StringBuffer code = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            code.append(serial.charAt(random.nextInt(n)));
        }
        return code.toString();
    }

    public static String getApplicationUrl(HttpServletRequest request) {
        String protocol = request.getProtocol().toLowerCase();
        protocol = protocol.startsWith("https") ? "https" : "http";
        String host = request.getServerName();
        int port = request.getServerPort();
        String context = request.getContextPath();
        String url = protocol + "://" + host;
        if (!(protocol.equals("http") && port == 80 || protocol.equals("https") && port == 443)) {
            url = url + ":" + port;
        }
        if (context != null && context.length() > 0) {
            if (!context.startsWith("/")) {
                url = url + "/";
            }
            url = url + context + "/";
        } else {
            url = url + "/";
        }
        return url;
    }

    public static synchronized long generateSequenceId() {
        if (sequenceInstance == null) {
            sequenceInstance = new Sequence();
        }
        return sequenceInstance.nextId();
    }

    public static String getRequestIP(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static String getConsoleRoot() {
        if (CONSOLE_ROOT != null) {
            return CONSOLE_ROOT;
        }
        String consoleRoot = Config.getProperty("console.root");
        if (consoleRoot == null || consoleRoot.trim().length() == 0) {
            log.log(9994, (Object)"\u5f53\u524d\u5e94\u7528\u672a\u914d\u7f6e console.root \u53c2\u6570\uff0c\u65e0\u6cd5\u5b9a\u4f4d\u6743\u9650\u7ba1\u7406\u7cfb\u7edf\u7684\u6839\u5730\u5740");
            return "/";
        }
        if (!consoleRoot.endsWith("/")) {
            consoleRoot = consoleRoot + "/";
        }
        CONSOLE_ROOT = consoleRoot;
        return CONSOLE_ROOT;
    }

    public static String getAccountTemporaryFile(Object accountId) throws BizException {
        String tempFolder;
        File folder;
        if (accountId == null) {
            throw new BizException("\u6307\u5b9a\u7684\u8d26\u6237\u7f16\u53f7\u4e3a\u7a7a\uff01");
        }
        String root = Config.getProperty("file.attachment.directory");
        if (root == null || root.trim().length() == 0) {
            throw new BizException("\u5728 application.properties \u6587\u4ef6\u4e2d\u6ca1\u6709\u914d\u7f6e \u9644\u4ef6\u6587\u4ef6\u6839\u76ee\u5f55\uff08KEY: file.attachment.directory\uff09\uff01");
        }
        if (!root.endsWith("/") && !root.endsWith("\\")) {
            root = root + File.separator;
        }
        if (!(folder = new File(tempFolder = root + "Temp" + File.separator)).exists()) {
            folder.mkdirs();
        }
        return tempFolder + accountId + ".dat";
    }

    static {
        String string = "Oracle".equalsIgnoreCase(SQLPool.getDatabaseName()) ? "NVL" : (ISNULL = "MySQL".equalsIgnoreCase(SQLPool.getDatabaseName()) ? "IFNULL" : "ISNULL");
        NOW = "Oracle".equalsIgnoreCase(SQLPool.getDatabaseName()) ? "SYSDATE" : ("MySQL".equalsIgnoreCase(SQLPool.getDatabaseName()) ? "NOW()" : "getDate()");
        CONSOLE_ROOT = null;
    }
}

