/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.config;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public final class Config {
    private static String config_file = "application";
    private static Properties prop = null;
    private static boolean loaded = false;
    private static String activeProfile = null;

    private Config() {
    }

    private static void initialize() {
        prop = new Properties();
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(config_file + ".properties");
            prop.load(is);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String profile = System.getenv("SPRING_PROFILES_ACTIVE");
        if (profile == null || profile.trim().length() == 0) {
            profile = System.getProperty("spring.profiles.active");
        }
        if (profile == null || profile.trim().length() == 0) {
            profile = prop.getProperty("spring.profiles.active");
        }
        if (profile != null && profile.trim().length() > 0) {
            activeProfile = profile.trim();
            try {
                InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(config_file + "-" + profile.trim() + ".properties");
                prop.load(is);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        loaded = true;
    }

    public static void refresh() {
        prop = null;
        loaded = false;
    }

    public static String getProperty(String key) {
        if (!loaded) {
            Config.initialize();
        }
        return prop.getProperty(key);
    }

    public static Enumeration<String> keys() {
        if (!loaded) {
            Config.initialize();
        }
        return new Enumeration<String>(){
            Enumeration<Object> keys = Config.access$000().keys();

            @Override
            public boolean hasMoreElements() {
                return this.keys.hasMoreElements();
            }

            @Override
            public String nextElement() {
                return (String)this.keys.nextElement();
            }
        };
    }

    public static String getActiveProfile() {
        if (!loaded) {
            Config.initialize();
        }
        if (activeProfile == null) {
            activeProfile = "";
        }
        return activeProfile;
    }

    static /* synthetic */ Properties access$000() {
        return prop;
    }
}

