/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.data.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import team.bangbang.common.utility.LogicUtility;

public class DataShaper {
    public static void writeField(Object obj, String exp, Object objValue) {
        int nIndex = exp.indexOf(".");
        String objectName = nIndex <= 0 ? exp : exp.substring(0, nIndex);
        Class<?> cls = obj.getClass();
        Field f = null;
        try {
            f = cls.getField(objectName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (f == null) {
            return;
        }
        if (nIndex <= 0) {
            try {
                f.set(obj, DataShaper.toObject(f.getType(), objValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        Object objField = null;
        try {
            objField = f.get(obj);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (objField == null) {
            return;
        }
        try {
            DataShaper.executeExpression(objField, exp.substring(nIndex + 1), objValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void executeExpression(Object objField, String strKey, Object objValue) throws Exception {
        int nIndex = strKey.indexOf(".");
        if (nIndex <= 0) {
            Method[] mtds;
            Field f = null;
            try {
                f = objField.getClass().getField(strKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (f != null) {
                objValue = DataShaper.toObject(f.getDeclaringClass(), objValue);
                f.set(objField, objValue);
                return;
            }
            String mtdSetName = "set" + DataShaper.upperFirst(strKey);
            for (Method m : mtds = objField.getClass().getMethods()) {
                Class<?>[] csP = m.getParameterTypes();
                if (!mtdSetName.equals(m.getName()) || csP == null || csP.length != 1) continue;
                try {
                    m.invoke(objField, DataShaper.toObject(csP[0], objValue));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        Field f = null;
        try {
            f = objField.getClass().getField(strKey);
        }
        catch (Exception mtdSetName) {
            // empty catch block
        }
        if (f != null) {
            Class<?> cls;
            Object returnValued = f.get(objField);
            if (returnValued == null && (returnValued = (cls = f.getDeclaringClass()).newInstance()) != null) {
                f.set(objField, returnValued);
            }
            if (returnValued != null) {
                strKey = strKey.substring(nIndex + 1);
                DataShaper.executeExpression(returnValued, strKey, objValue);
                return;
            }
        }
        String mtdGetName = "get" + DataShaper.upperFirst(strKey.substring(0, nIndex));
        Method mtdGet = objField.getClass().getMethod(mtdGetName, new Class[0]);
        Object returnValued = mtdGet.invoke(objField, new Object[0]);
        if (returnValued == null) {
            Class<?> cls = mtdGet.getReturnType();
            if (cls == null) {
                return;
            }
            returnValued = cls.newInstance();
            if (returnValued == null) {
                return;
            }
            String mtdSetName = "set" + DataShaper.upperFirst(strKey.substring(0, nIndex));
            Method mtdSet = objField.getClass().getMethod(mtdSetName, cls);
            mtdSet.invoke(objField, returnValued);
        }
        strKey = strKey.substring(nIndex + 1);
        DataShaper.executeExpression(returnValued, strKey, objValue);
    }

    private static String upperFirst(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static Object toObject(Class<?> clsF, Object objValue) throws ParseException {
        if (clsF.equals(String.class)) {
            if (objValue == null) {
                return null;
            }
            if (objValue.getClass().isArray()) {
                int len = Array.getLength(objValue);
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < len; ++i) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(Array.get(objValue, i));
                }
                return sb.toString();
            }
            return objValue.toString();
        }
        if (clsF.equals(Integer.class)) {
            try {
                if (objValue == null) {
                    return null;
                }
                String s = String.valueOf(objValue).trim();
                if (s.length() == 0) {
                    return null;
                }
                int n = Integer.parseInt(s);
                return new Integer(n);
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (clsF.equals(Integer.TYPE)) {
            try {
                int n = Integer.parseInt(String.valueOf(objValue));
                return n;
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (clsF.equals(Long.class)) {
            try {
                if (objValue == null) {
                    return null;
                }
                String s = String.valueOf(objValue).trim();
                if (s.length() == 0) {
                    return null;
                }
                long l = Long.parseLong(s);
                return new Long(l);
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (clsF.equals(Long.TYPE)) {
            try {
                long l = Long.parseLong(String.valueOf(objValue));
                return l;
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (clsF.equals(Boolean.class)) {
            try {
                if (objValue == null) {
                    return null;
                }
                String s = String.valueOf(objValue).trim();
                if (s.length() == 0) {
                    return null;
                }
                if ("true".equals(s = s.toLowerCase())) {
                    return true;
                }
                if ("false".equals(s)) {
                    return false;
                }
                return null;
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (clsF.equals(Boolean.TYPE)) {
            try {
                boolean bl = Boolean.parseBoolean(String.valueOf(objValue));
                return bl;
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (clsF.equals(Double.class)) {
            try {
                if (objValue == null) {
                    return null;
                }
                String s = String.valueOf(objValue).trim();
                if (s.length() == 0) {
                    return null;
                }
                double d = Double.parseDouble(s);
                return new Double(d);
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (clsF.equals(Double.TYPE)) {
            try {
                double d = Double.parseDouble(String.valueOf(objValue));
                return d;
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (clsF.equals(Date.class)) {
            try {
                if (objValue == null) {
                    return null;
                }
                String s = String.valueOf(objValue).trim();
                if (s.length() == 0) {
                    return null;
                }
                return DataShaper.parseDate(s);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return objValue;
    }

    private static Date parseDate(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).length() == 0) {
            return null;
        }
        str = str.replace('/', '-');
        String[] sa = (str = str.replace('\\', '-')).split("\\s+");
        if (sa == null || sa.length == 0) {
            return null;
        }
        String s1 = null;
        String s2 = null;
        if (sa.length == 1) {
            if (sa[0].indexOf(":") > 0) {
                s2 = sa[0];
            } else {
                s1 = sa[0];
            }
        }
        if (sa.length >= 2) {
            for (int i = 0; sa != null && i < 2 && i < sa.length; ++i) {
                if (sa[i].indexOf(":") > 0 || s1 != null) {
                    s2 = sa[i];
                    continue;
                }
                s1 = sa[i];
            }
        }
        if (s1 == null) {
            s1 = "1900-01-01";
        }
        if (s2 == null) {
            s2 = "00:00:00";
        }
        int[] ymd = DataShaper.getYmd(s1);
        int[] hms = DataShaper.getHms(s2);
        Calendar cal = Calendar.getInstance();
        cal.set(ymd[0], ymd[1] - 1, ymd[2], hms[0], hms[1], hms[2]);
        return cal.getTime();
    }

    private static int[] getHms(String s2) {
        int[] hms = new int[]{0, 0, 0};
        int nEnd = s2.indexOf(":");
        if (nEnd < 0) {
            hms[0] = LogicUtility.parseInt(s2, hms[0]);
            return hms;
        }
        int nStart = 0;
        hms[0] = LogicUtility.parseInt(s2.substring(nStart, nEnd), hms[0]);
        nStart = nEnd + 1;
        if (nStart >= s2.length()) {
            return hms;
        }
        nEnd = s2.indexOf(":", nStart);
        if (nEnd < 0) {
            hms[1] = LogicUtility.parseInt(s2.substring(nStart), hms[1]);
            nEnd = s2.length();
        } else {
            hms[1] = LogicUtility.parseInt(s2.substring(nStart, nEnd), hms[1]);
        }
        nStart = nEnd + 1;
        if (nStart >= s2.length()) {
            return hms;
        }
        hms[2] = LogicUtility.parseInt(s2.substring(nStart), hms[2]);
        return hms;
    }

    private static int[] getYmd(String s1) {
        int[] ymd = new int[]{1900, 1, 1};
        int nEnd = s1.indexOf("-");
        if (nEnd < 0) {
            ymd[0] = LogicUtility.parseInt(s1, ymd[0]);
            return ymd;
        }
        int nStart = 0;
        ymd[0] = LogicUtility.parseInt(s1.substring(nStart, nEnd), ymd[0]);
        nStart = nEnd + 1;
        if (nStart >= s1.length()) {
            return ymd;
        }
        nEnd = s1.indexOf("-", nStart);
        if (nEnd < 0) {
            ymd[1] = LogicUtility.parseInt(s1.substring(nStart), ymd[1]);
            nEnd = s1.length();
        } else {
            ymd[1] = LogicUtility.parseInt(s1.substring(nStart, nEnd), ymd[1]);
        }
        nStart = nEnd + 1;
        if (nStart >= s1.length()) {
            return ymd;
        }
        ymd[2] = LogicUtility.parseInt(s1.substring(nStart), ymd[2]);
        return ymd;
    }
}

