/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.data.util;

import java.io.File;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import team.bangbang.common.config.Config;
import team.bangbang.common.utility.LogicUtility;

public final class Transport {
    private static String tempSaveDir = System.getProperty("java.io.tmpdir");
    private static int maxSize = LogicUtility.parseInt(Config.getProperty("multipart.maxSize"), 524288);
    private static Pattern scriptStart = Pattern.compile("<\\s*script[^>|.]*>", 2);
    private static Pattern scriptEnd = Pattern.compile("<\\s*/\\s*script[^>|.]*>", 2);
    private static final String UPLOAD_PROGRESS_PREFIX = "UPLOAD_PROGRESS_PREFIX";

    public static void transport(HttpServletRequest request, Map<String, Object> data) {
        String strEnctype = request.getContentType();
        if (strEnctype != null && strEnctype.startsWith("multipart/form-data") && strEnctype.indexOf("boundary=") != -1) {
            Transport.readRequestInStream(request, data);
            HttpSession session = request.getSession();
            Enumeration er = session.getAttributeNames();
            while (er != null && er.hasMoreElements()) {
                String key = (String)er.nextElement();
                if (!key.startsWith(UPLOAD_PROGRESS_PREFIX)) continue;
                session.removeAttribute(key);
            }
        }
        Transport.readRequestURLParameter(request, data);
    }

    private static void readRequestURLParameter(HttpServletRequest request, Map<String, Object> data) {
        Enumeration er = request.getParameterNames();
        int i = 0;
        int nLen = 0;
        String strKey = null;
        String[] strValues = null;
        while (er != null && er.hasMoreElements()) {
            strKey = (String)er.nextElement();
            strValues = request.getParameterValues(strKey);
            if (strValues == null || strValues.length <= 0) continue;
            nLen = strValues.length;
            for (i = 0; i < nLen; ++i) {
                Transport.setParameter(data, strKey, strValues[i]);
            }
        }
    }

    private static void readRequestInStream(HttpServletRequest request, Map<String, Object> data) {
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setRepository(new File(tempSaveDir));
        factory.setSizeThreshold(2048);
        ServletFileUpload fu = new ServletFileUpload((FileItemFactory)factory);
        fu.setSizeMax((long)maxSize);
        fu.setHeaderEncoding("UTF-8");
        try {
            List fileItems = fu.parseRequest(request);
            int nCount = fileItems == null ? 0 : fileItems.size();
            for (int i = 0; i < nCount; ++i) {
                FileItem item = (FileItem)fileItems.get(i);
                String eleName = item.getFieldName();
                if (item.isFormField()) {
                    Transport.setParameter(data, eleName, item.getString());
                    continue;
                }
                String clientFileName = item.getName();
                if (clientFileName == null || clientFileName.trim().length() == 0) continue;
                Transport.setParameter(data, eleName, clientFileName);
                long size = item.getSize();
                if (size == 0L) continue;
                File dir = new File(tempSaveDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File savedFile = new File(tempSaveDir, System.currentTimeMillis() + "." + LogicUtility.getFileExtension(clientFileName));
                item.write(savedFile);
                Transport.setParameter(data, eleName, savedFile);
            }
        }
        catch (FileUploadException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setParameter(Map<String, Object> data, String name, Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof String && Transport.hasScriptTag(name, (String)value)) {
            return;
        }
        Object obj = data.get(name);
        if (obj == null) {
            data.put(name, value);
            return;
        }
        Object[] valueArray = null;
        Object[] temp = null;
        temp = obj instanceof Object[] ? (Object[])obj : new Object[]{obj};
        int count = temp.length;
        valueArray = new Object[count + 1];
        for (int i = 0; i < count; ++i) {
            valueArray[i] = temp[i];
        }
        valueArray[count] = value;
        data.put(name, valueArray);
    }

    private static boolean hasScriptTag(String name, String value) {
        if (name == null || value == null) {
            return false;
        }
        if (((name = name.toUpperCase()).endsWith("ID") || name.endsWith("FLAG")) && value.length() > 50) {
            return true;
        }
        boolean blA = scriptStart.matcher(value).find();
        if (blA) {
            return true;
        }
        boolean blB = scriptEnd.matcher(value).find();
        return blB;
    }
}

