/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.exp;

import java.awt.Dimension;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import team.bangbang.common.CommonMPI;
import team.bangbang.common.exception.BizException;
import team.bangbang.common.exp.Exporter;
import team.bangbang.common.file.ExcelWriter;
import team.bangbang.common.sql.SQLPool;

public class SqlExporter
extends Exporter {
    private Object accountId = null;
    private String sql = null;
    private String excelFileName = null;

    public SqlExporter(Object accountId, String sql, String excelFileName) {
        this.accountId = accountId;
        this.sql = sql;
        this.excelFileName = excelFileName;
    }

    @Override
    public String[] export() throws BizException {
        if (this.sql == null || this.titles == null || this.fields == null) {
            throw new BizException("\u8bf7\u9996\u5148\u6267\u884c\u67e5\u8be2\uff0c\u7136\u540e\u518d\u6267\u884c\u5bfc\u51fa\uff01");
        }
        ExcelWriter ew = null;
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        try {
            conn = SQLPool.getConnection();
            st = conn.createStatement();
            rs = st.executeQuery(this.sql);
            String tempFile = CommonMPI.getAccountTemporaryFile(this.accountId);
            ew = new ExcelWriter(tempFile);
            int count = 0;
            while (rs.next()) {
                if (count % 60000 == 0) {
                    int nIndex = count / 60000;
                    ew.createSheet("\u6570\u636e " + (nIndex + 1), nIndex);
                    ew.toRow(1);
                    ew.toColumn(1);
                    Dimension off1 = ew.getOffset();
                    for (int i = 0; i < this.titles.length; ++i) {
                        if (!this.selectedFields.contains(this.fields[i])) continue;
                        ew.writeCell(this.titles[i]);
                    }
                    Dimension off2 = ew.getOffset();
                    ew.setHeader(off1, off2);
                }
                ew.nextRow();
                ew.toColumn(1);
                for (int i = 0; i < this.fields.length; ++i) {
                    if (!this.selectedFields.contains(this.fields[i])) continue;
                    Object s = this.fields[i] == null || this.fields[i].trim().length() == 0 ? null : this.getObject(rs, this.fields[i]);
                    ew.writeCell(s);
                }
                ++count;
            }
        }
        catch (Exception e) {
            throw new BizException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (ew != null) {
                    ew.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String s = this.excelFileName + ".xls";
        try {
            s = URLEncoder.encode(s, "UTF-8");
            s = URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String[] result = new String[]{"Temp/" + this.accountId + ".dat", s};
        return result;
    }

    protected Object getObject(ResultSet rs, String fieldName) {
        try {
            return rs.getObject(fieldName);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

