/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.file;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.activation.MimetypesFileTypeMap;
import team.bangbang.common.config.Config;
import team.bangbang.common.file.IFileManager;

public class AliyunOssManager
implements IFileManager {
    private static String bucketName = Config.getProperty("file.attachment.manager.aliyun.oss.bucketName");
    private static String accessKeyId = Config.getProperty("file.attachment.manager.aliyun.oss.accessKeyId");
    private static String accessKeySecret = Config.getProperty("file.attachment.manager.aliyun.oss.accessKeySecret");
    private static String endpoint = Config.getProperty("file.attachment.manager.aliyun.oss.endpoint");
    private static String aliyunRoot = Config.getProperty("file.attachment.manager.aliyun.root");
    private static OSS ossClient = null;

    @Override
    public String put(String localFile, String destSliceFile) throws IOException {
        File lf = new File(localFile);
        String contentType = new MimetypesFileTypeMap().getContentType(destSliceFile);
        ObjectMetadata meta = new ObjectMetadata();
        meta.setContentLength(lf.length());
        meta.setContentType(contentType);
        ossClient.putObject(bucketName, destSliceFile, lf, meta);
        return (aliyunRoot + destSliceFile).replace('\\', '/');
    }

    @Override
    public boolean exist(String destSliceFile) throws IOException {
        try {
            return ossClient.doesObjectExist(bucketName, destSliceFile);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public InputStream get(String destFile) throws IOException {
        return null;
    }

    static {
        try {
            ossClient = new OSSClientBuilder().build(endpoint, accessKeyId, accessKeySecret);
            if (!ossClient.doesBucketExist(bucketName)) {
                CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucketName);
                ossClient.createBucket(createBucketRequest);
            }
            if (aliyunRoot == null) {
                aliyunRoot = "";
            }
            if (!(aliyunRoot = aliyunRoot.replace('\\', '/')).endsWith("/")) {
                aliyunRoot = aliyunRoot + "/";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

