/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

public class ExcelReader {
    private Workbook workbook = null;
    private Sheet sheet = null;
    private int rowNo = 0;
    private int columnNo = 0;
    private int rowCount = 0;
    private int columnCount = 0;

    public ExcelReader(String excelFile) throws BiffException, IOException {
        if (excelFile.toLowerCase().startsWith("http://") || excelFile.toLowerCase().startsWith("https://")) {
            URL url = new URL(excelFile);
            InputStream is = url.openStream();
            this.workbook = Workbook.getWorkbook((InputStream)is);
        } else {
            this.workbook = Workbook.getWorkbook((File)new File(excelFile));
        }
    }

    public ExcelReader(InputStream is) throws BiffException, IOException {
        this.workbook = Workbook.getWorkbook((InputStream)is);
    }

    public void setSheetIndex(int nIndex) {
        this.sheet = this.workbook.getSheet(nIndex);
        this.rowNo = 0;
        this.columnNo = 0;
        this.rowCount = this.sheet.getRows();
        this.columnCount = this.sheet.getColumns();
    }

    public boolean nextRow() {
        ++this.rowNo;
        this.columnNo = 0;
        return this.rowNo < this.rowCount;
    }

    public void toRow(int nRow) {
        this.rowNo = nRow;
        this.columnNo = 0;
    }

    public void toColumn(int nColumn) {
        this.columnNo = nColumn;
    }

    public String readCell() {
        if (this.sheet == null) {
            return null;
        }
        if (this.rowNo >= this.rowCount || this.columnNo >= this.columnCount) {
            return null;
        }
        return this.sheet.getCell(this.columnNo++, this.rowNo).getContents();
    }

    public String readCell(int column, int row) {
        if (this.sheet == null) {
            return null;
        }
        if (row >= this.rowCount || column >= this.columnCount) {
            return null;
        }
        return this.sheet.getCell(column, row).getContents();
    }

    public int getRowCount() {
        if (this.sheet == null) {
            return -1;
        }
        return this.rowCount;
    }

    public int getColumnCount() {
        if (this.sheet == null) {
            return -1;
        }
        return this.columnCount;
    }

    public void close() {
        this.workbook.close();
    }
}

