/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.file;

import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import jxl.Cell;
import jxl.SheetSettings;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.biff.FontRecord;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Font;
import jxl.format.UnderlineStyle;
import jxl.format.VerticalAlignment;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;

public class ExcelWriter {
    private WritableWorkbook workbook = null;
    private WritableSheet sheet = null;
    private int rowNo = 0;
    private int columnNo = 0;
    private int fontSize = 10;
    private boolean hasWrite = false;

    public ExcelWriter(OutputStream os) throws IOException, WriteException {
        WorkbookSettings ws = new WorkbookSettings();
        ws.setLocale(Locale.getDefault());
        this.workbook = Workbook.createWorkbook((OutputStream)os, (WorkbookSettings)ws);
    }

    public ExcelWriter(String excelFile) throws IOException, WriteException {
        WorkbookSettings ws = new WorkbookSettings();
        ws.setLocale(Locale.getDefault());
        this.workbook = Workbook.createWorkbook((File)new File(excelFile), (WorkbookSettings)ws);
    }

    private CellFormat getCellFormat() {
        WritableCellFormat wcf = new WritableCellFormat((CellFormat)WritableWorkbook.NORMAL_STYLE);
        try {
            wcf.setWrap(true);
        }
        catch (WriteException writeException) {
            // empty catch block
        }
        WritableFont wf = new WritableFont(WritableFont.ARIAL, this.fontSize, WritableFont.NO_BOLD, false, UnderlineStyle.NO_UNDERLINE, Colour.BLACK);
        wcf.setFont((FontRecord)wf);
        return wcf;
    }

    private WritableCellFormat cloneCellFormat(CellFormat cf) throws WriteException {
        Border[] bs;
        WritableCellFormat wcf = new WritableCellFormat((CellFormat)WritableWorkbook.NORMAL_STYLE);
        Colour bgColor = cf.getBackgroundColour();
        if (!bgColor.equals(Colour.DEFAULT_BACKGROUND) && !bgColor.equals(Colour.DEFAULT_BACKGROUND1)) {
            wcf.setBackground(bgColor);
        }
        Font f = cf.getFont();
        wcf.setFont((FontRecord)f);
        wcf.setAlignment(cf.getAlignment());
        wcf.setVerticalAlignment(cf.getVerticalAlignment());
        for (Border b : bs = new Border[]{Border.ALL, Border.TOP, Border.RIGHT, Border.BOTTOM, Border.LEFT}) {
            BorderLineStyle bls = cf.getBorderLine(b);
            Colour c = cf.getBorderColour(b);
            wcf.setBorder(b, bls, c);
        }
        return wcf;
    }

    public void createSheet(String strName, int nIndex) {
        this.sheet = this.workbook.createSheet(strName, nIndex);
        SheetSettings ss = this.sheet.getSettings();
        if (ss != null) {
            int i = 0;
            while (i++ < 100) {
                ss.setFitWidth(i);
            }
        }
        this.rowNo = 0;
        this.columnNo = 0;
        this.hasWrite = false;
    }

    public void setSheetIndex(int nIndex) {
        this.sheet = this.workbook.getSheet(nIndex);
        this.rowNo = 0;
        this.columnNo = 0;
        this.hasWrite = false;
    }

    public boolean nextRow() {
        ++this.rowNo;
        this.columnNo = 0;
        this.hasWrite = false;
        return true;
    }

    public void toRow(int nRow) {
        this.rowNo = nRow;
        this.columnNo = 0;
        this.hasWrite = false;
    }

    public void toColumn(int nColumn) {
        this.columnNo = nColumn;
        this.hasWrite = false;
    }

    public Dimension getOffset() {
        return new Dimension(this.hasWrite ? this.columnNo - 1 : this.columnNo, this.rowNo);
    }

    public void merge(Dimension offset1, Dimension offset2) throws RowsExceededException, WriteException {
        this.sheet.mergeCells(offset1.width, offset1.height, offset2.width, offset2.height);
    }

    public void writeCell(Object content) throws RowsExceededException, WriteException {
        if (content == null) {
            content = "";
        }
        Label l = new Label(this.columnNo++, this.rowNo, content.toString(), this.getCellFormat());
        this.sheet.addCell((WritableCell)l);
        this.hasWrite = true;
    }

    public void writeImage(String imagePath, double imageWidth, double imageHeight) {
        File f = new File(imagePath);
        WritableImage img = new WritableImage((double)this.columnNo, (double)this.rowNo, imageWidth, imageHeight, f);
        this.sheet.addImage(img);
    }

    public void setHeader(Dimension offset1, Dimension offset2) throws WriteException {
        int x1 = offset1.width;
        int y1 = offset1.height;
        int x2 = offset2.width;
        int y2 = offset2.height;
        for (int i = x1; i <= x2; ++i) {
            for (int j = y1; j <= y2; ++j) {
                WritableCellFormat cf = (WritableCellFormat)this.getCellFormat();
                cf.setBackground(Colour.OCEAN_BLUE);
                WritableFont wf = (WritableFont)cf.getFont();
                wf.setColour(Colour.WHITE);
                wf.setBoldStyle(WritableFont.BOLD);
                if (j == y1) {
                    cf.setBorder(Border.TOP, BorderLineStyle.THIN, Colour.LIGHT_BLUE);
                } else {
                    cf.setBorder(Border.TOP, BorderLineStyle.DOTTED, Colour.ICE_BLUE);
                }
                if (i == x2) {
                    cf.setBorder(Border.RIGHT, BorderLineStyle.THIN, Colour.LIGHT_BLUE);
                } else {
                    cf.setBorder(Border.RIGHT, BorderLineStyle.DOTTED, Colour.ICE_BLUE);
                }
                if (j == y2) {
                    cf.setBorder(Border.BOTTOM, BorderLineStyle.THIN, Colour.ICE_BLUE);
                } else {
                    cf.setBorder(Border.BOTTOM, BorderLineStyle.DOTTED, Colour.ICE_BLUE);
                }
                if (i == x1) {
                    cf.setBorder(Border.LEFT, BorderLineStyle.THIN, Colour.LIGHT_BLUE);
                } else {
                    cf.setBorder(Border.LEFT, BorderLineStyle.DOTTED, Colour.ICE_BLUE);
                }
                cf.setAlignment(Alignment.CENTRE);
                cf.setVerticalAlignment(VerticalAlignment.CENTRE);
                Cell c = this.sheet.getCell(i, j);
                if (!(c instanceof Label)) {
                    Label l = new Label(i, j, "", (CellFormat)cf);
                    this.sheet.addCell((WritableCell)l);
                    continue;
                }
                ((Label)c).setCellFormat((CellFormat)cf);
            }
        }
    }

    public void setFooter(Dimension offset1, Dimension offset2) throws WriteException {
        int x1 = offset1.width;
        int y1 = offset1.height;
        int x2 = offset2.width;
        int y2 = offset2.height;
        for (int i = x1; i <= x2; ++i) {
            for (int j = y1; j <= y2; ++j) {
                WritableCellFormat cf = (WritableCellFormat)this.getCellFormat();
                cf.setBackground(Colour.GRAY_25);
                WritableFont wf = (WritableFont)cf.getFont();
                wf.setColour(Colour.DARK_RED);
                wf.setBoldStyle(WritableFont.BOLD);
                if (j == y1) {
                    cf.setBorder(Border.TOP, BorderLineStyle.THIN, Colour.GRAY_50);
                } else {
                    cf.setBorder(Border.TOP, BorderLineStyle.DOTTED, Colour.GRAY_80);
                }
                if (i == x2) {
                    cf.setBorder(Border.RIGHT, BorderLineStyle.THIN, Colour.GRAY_50);
                } else {
                    cf.setBorder(Border.RIGHT, BorderLineStyle.DOTTED, Colour.GRAY_80);
                }
                if (j == y2) {
                    cf.setBorder(Border.BOTTOM, BorderLineStyle.THIN, Colour.GRAY_80);
                } else {
                    cf.setBorder(Border.BOTTOM, BorderLineStyle.DOTTED, Colour.GRAY_80);
                }
                if (i == x1) {
                    cf.setBorder(Border.LEFT, BorderLineStyle.THIN, Colour.GRAY_50);
                } else {
                    cf.setBorder(Border.LEFT, BorderLineStyle.DOTTED, Colour.GRAY_80);
                }
                cf.setAlignment(Alignment.CENTRE);
                cf.setVerticalAlignment(VerticalAlignment.CENTRE);
                Cell c = this.sheet.getCell(i, j);
                if (!(c instanceof Label)) {
                    Label l = new Label(i, j, "", (CellFormat)cf);
                    this.sheet.addCell((WritableCell)l);
                    continue;
                }
                ((Label)c).setCellFormat((CellFormat)cf);
            }
        }
    }

    public void setBorder(Dimension offset1, Dimension offset2) throws WriteException {
        int x1 = offset1.width;
        int y1 = offset1.height;
        int x2 = offset2.width;
        int y2 = offset2.height;
        for (int i = x1; i <= x2; ++i) {
            for (int j = y1; j <= y2; ++j) {
                WritableCellFormat cf;
                CellFormat cf1 = this.sheet.getCell(i, j).getCellFormat();
                WritableCellFormat writableCellFormat = cf = cf1 != null ? this.cloneCellFormat(cf1) : new WritableCellFormat();
                if (j == y1) {
                    cf.setBorder(Border.TOP, BorderLineStyle.THIN, Colour.LIGHT_BLUE);
                } else {
                    cf.setBorder(Border.TOP, BorderLineStyle.DOTTED, Colour.LIGHT_BLUE);
                }
                if (i == x2) {
                    cf.setBorder(Border.RIGHT, BorderLineStyle.THIN, Colour.LIGHT_BLUE);
                } else {
                    cf.setBorder(Border.RIGHT, BorderLineStyle.DOTTED, Colour.LIGHT_BLUE);
                }
                if (j == y2) {
                    cf.setBorder(Border.BOTTOM, BorderLineStyle.THIN, Colour.LIGHT_BLUE);
                } else {
                    cf.setBorder(Border.BOTTOM, BorderLineStyle.DOTTED, Colour.LIGHT_BLUE);
                }
                if (i == x1) {
                    cf.setBorder(Border.LEFT, BorderLineStyle.THIN, Colour.LIGHT_BLUE);
                } else {
                    cf.setBorder(Border.LEFT, BorderLineStyle.DOTTED, Colour.LIGHT_BLUE);
                }
                Cell c = this.sheet.getCell(i, j);
                if (!(c instanceof Label)) {
                    Label l = new Label(i, j, "", (CellFormat)cf);
                    this.sheet.addCell((WritableCell)l);
                    continue;
                }
                ((Label)c).setCellFormat((CellFormat)cf);
            }
        }
    }

    public void setAlignment(Dimension offset1, Dimension offset2, String align) throws WriteException {
        if (align == null) {
            return;
        }
        align = align.trim().toLowerCase();
        int x1 = offset1.width;
        int y1 = offset1.height;
        int x2 = offset2.width;
        int y2 = offset2.height;
        Alignment ali = null;
        if ("left".equals(align)) {
            ali = Alignment.LEFT;
        } else if ("center".equals(align)) {
            ali = Alignment.CENTRE;
        } else if ("centre".equals(align)) {
            ali = Alignment.CENTRE;
        } else if ("right".equals(align)) {
            ali = Alignment.RIGHT;
        } else if ("justify".equals(align)) {
            ali = Alignment.JUSTIFY;
        }
        VerticalAlignment val = null;
        if (ali == null) {
            if ("top".equals(align)) {
                val = VerticalAlignment.TOP;
            } else if ("middle".equals(align)) {
                val = VerticalAlignment.CENTRE;
            } else if ("bottom".equals(align)) {
                val = VerticalAlignment.BOTTOM;
            }
            if (val == null) {
                return;
            }
        }
        for (int i = x1; i <= x2; ++i) {
            for (int j = y1; j <= y2; ++j) {
                WritableCellFormat cf;
                CellFormat cf1 = this.sheet.getCell(i, j).getCellFormat();
                WritableCellFormat writableCellFormat = cf = cf1 != null ? this.cloneCellFormat(cf1) : new WritableCellFormat();
                if (ali != null) {
                    cf.setAlignment(ali);
                } else {
                    cf.setVerticalAlignment(val);
                }
                Cell c = this.sheet.getCell(i, j);
                if (!(c instanceof Label)) {
                    Label l = new Label(i, j, "", (CellFormat)cf);
                    this.sheet.addCell((WritableCell)l);
                    continue;
                }
                ((Label)c).setCellFormat((CellFormat)cf);
            }
        }
    }

    public void setColumnWidth(int columnIndex, int width) throws RowsExceededException, WriteException {
        this.sheet.setColumnView(columnIndex, width);
    }

    public void setRowHeight(int rowIndex, int height) throws RowsExceededException, WriteException {
        this.sheet.setRowView(rowIndex, height);
    }

    public void close() throws IOException, WriteException {
        this.workbook.write();
        this.workbook.close();
    }
}

