/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class FileReader {
    private File file = null;

    public FileReader(String strFile) throws IOException {
        this.file = new File(strFile);
        if (!this.file.exists() || this.file.isDirectory()) {
            throw new IOException("File not exist or is directory.");
        }
    }

    public FileReader(File f) throws IOException {
        this.file = f;
        if (!this.file.exists() || this.file.isDirectory()) {
            throw new IOException("File not exist or is directory.");
        }
    }

    public String readString() throws IOException {
        return new String(this.readBytes());
    }

    public String readString(String charset) throws UnsupportedEncodingException, IOException {
        return new String(this.readBytes(), charset);
    }

    public byte[] readBytes() throws IOException {
        int nLen = (int)this.file.length();
        byte[] byBuf = new byte[nLen];
        FileInputStream reader = null;
        try {
            reader = new FileInputStream(this.file);
            reader.read(byBuf);
        }
        catch (IOException iex) {
            throw iex;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        return byBuf;
    }
}

