/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.file;

import java.io.InputStream;
import java.net.URL;
import team.bangbang.common.exception.BizException;

public class ResourceLoader {
    public static InputStream getInputStream(Class<?> cls, String resourceFile) throws BizException {
        String pkg;
        String string = pkg = cls != null ? cls.getPackage().getName() : null;
        if (pkg != null && pkg.length() > 0) {
            resourceFile = pkg.replace('.', '/') + '/' + resourceFile;
        }
        resourceFile = resourceFile.replaceAll("^/+", "");
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceFile);
        if (is == null) {
            throw new BizException("File (" + resourceFile + ") is not exist.");
        }
        return is;
    }

    public static String getPath(Class<?> cls, String resourceFile) throws BizException {
        URL url;
        String pkg = cls.getPackage().getName();
        if (pkg != null && pkg.length() > 0) {
            resourceFile = pkg.replace('.', '/') + '/' + resourceFile;
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource(resourceFile)) == null) {
            throw new BizException("File (" + resourceFile + ") is not exist.");
        }
        return url.getFile();
    }
}

