/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.file;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class Serialization {
    public static byte[] serialize(Serializable obj) throws IOException {
        if (obj == null) {
            return null;
        }
        try (ObjectOutputStream oos = null;){
            byte[] datas;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            oos.flush();
            byte[] byArray = datas = baos.toByteArray();
            return byArray;
        }
    }

    public static void serialize(Serializable obj, String file) throws IOException {
        if (obj == null || file == null || file.length() == 0) {
            return;
        }
        File f = new File(file);
        File folder = f.getParentFile();
        if (folder != null && !folder.exists()) {
            folder.mkdirs();
        }
        try (ObjectOutputStream oos = null;){
            oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(obj);
            oos.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Serializable unserialize(byte[] datas) throws IOException {
        if (datas == null || datas.length == 0) {
            return null;
        }
        Serializable obj = null;
        try (ObjectInputStream ois = null;){
            ByteArrayInputStream bais = new ByteArrayInputStream(datas);
            ois = new ObjectInputStream(bais);
            obj = (Serializable)ois.readObject();
        }
        return obj;
    }
}

