/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.filter;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import team.bangbang.common.config.Config;
import team.bangbang.common.config.Constants;
import team.bangbang.common.data.response.DtoResponse;
import team.bangbang.common.log.Logger;
import team.bangbang.sso.client.IAccountClient;
import team.bangbang.sso.client.IApplicationClient;
import team.bangbang.sso.client.IDataLimitClient;
import team.bangbang.sso.client.IFunctionLimitClient;

@WebFilter(filterName="SSOClientFilter", urlPatterns={"/microservice/*"})
public class SSOClientFilter
implements Filter {
    private static Logger log = Logger.getInstance(SSOClientFilter.class);
    private static String[] no_validation_modules = null;
    private static String[] no_validation_urls = null;
    private static String login_url = null;

    public void init(FilterConfig argFilterConfig) throws ServletException {
        String slogin_url;
        String urls;
        String modules = argFilterConfig.getInitParameter("no_validation_modules");
        if (modules == null || modules.trim().length() == 0) {
            modules = Config.getProperty("filter.SSOClientFilter.parameter.no_validation_modules");
        }
        if ((urls = argFilterConfig.getInitParameter("no_validation_urls")) == null || urls.trim().length() == 0) {
            urls = Config.getProperty("filter.SSOClientFilter.parameter.no_validation_urls");
        }
        login_url = (slogin_url = argFilterConfig.getInitParameter("login_url")) == null || slogin_url.trim().length() == 0 ? Config.getProperty("filter.SSOClientFilter.parameter.login_url") : slogin_url;
        if (modules != null && modules.trim().length() > 0) {
            no_validation_modules = modules.split("\\s+");
        }
        if (no_validation_modules == null) {
            no_validation_modules = new String[0];
        }
        if (urls != null && urls.trim().length() > 0) {
            no_validation_urls = urls.split("\\s+");
        }
        if (no_validation_urls == null) {
            no_validation_urls = new String[0];
        }
    }

    public void doFilter(ServletRequest argRequest, ServletResponse argResponse, FilterChain argChain) throws IOException, ServletException {
        IFunctionLimitClient flClt;
        IDataLimitClient dlClt;
        IAccountClient accClt;
        HttpServletRequest request = (HttpServletRequest)argRequest;
        HttpServletResponse response = (HttpServletResponse)argResponse;
        this.addCrossHeader(response);
        String method = request.getMethod();
        if (method.equalsIgnoreCase("OPTIONS")) {
            String s = response.getHeader("Access-Control-Allow-Headers");
            if (s == null) {
                response.addHeader("Access-Control-Allow-Headers", "content-type,token");
            }
            response.setStatus(200);
            return;
        }
        IApplicationClient appClt = this.getApplicationClient(request);
        if (appClt != null) {
            request.setAttribute(Constants.KEY_SSO_CLIENT_APPLICATION, (Object)appClt);
        }
        if ((accClt = this.getAccountClient(request)) != null) {
            request.setAttribute(Constants.KEY_SSO_CLIENT_ACCOUNT, (Object)accClt);
        }
        if ((dlClt = this.getDataLimitClient(request)) != null) {
            request.setAttribute(Constants.KEY_SSO_CLIENT_APPLICATION, (Object)dlClt);
        }
        if ((flClt = this.getFunctionLimitClient(request)) != null) {
            request.setAttribute(Constants.KEY_SSO_CLIENT_APPLICATION, (Object)flClt);
        }
        String strURI = request.getRequestURI().trim();
        strURI = strURI.replaceAll("/+", "/");
        if (this.ignoreValidation(strURI = strURI.substring(request.getContextPath().length()))) {
            argChain.doFilter(argRequest, argResponse);
            return;
        }
        if (flClt != null && flClt.canVisit()) {
            argChain.doFilter(argRequest, argResponse);
            return;
        }
        DtoResponse<String> rb = new DtoResponse<String>(300, "\u65e0\u6743\u9650");
        rb.setDto(login_url);
        response.getWriter().print(JSONObject.toJSONString(rb));
    }

    private IApplicationClient getApplicationClient(HttpServletRequest request) {
        String clazz = Config.getProperty("filter.SSOClientFilter.sso.client.application");
        if (clazz == null || clazz.trim().length() == 0) {
            return null;
        }
        try {
            return (IApplicationClient)Class.forName(clazz).newInstance();
        }
        catch (Exception ex) {
            log.log(9993, (Object)ex.getMessage());
            return null;
        }
    }

    private IAccountClient getAccountClient(HttpServletRequest request) {
        String clazz = Config.getProperty("filter.SSOClientFilter.sso.client.account");
        if (clazz == null || clazz.trim().length() == 0) {
            return null;
        }
        try {
            return (IAccountClient)Class.forName(clazz).newInstance();
        }
        catch (Exception ex) {
            log.log(9993, (Object)ex.getMessage());
            return null;
        }
    }

    private IDataLimitClient getDataLimitClient(HttpServletRequest request) {
        String clazz = Config.getProperty("filter.SSOClientFilter.sso.client.data.limit");
        if (clazz == null || clazz.trim().length() == 0) {
            return null;
        }
        try {
            return (IDataLimitClient)Class.forName(clazz).newInstance();
        }
        catch (Exception ex) {
            log.log(9993, (Object)ex.getMessage());
            return null;
        }
    }

    private IFunctionLimitClient getFunctionLimitClient(HttpServletRequest request) {
        String clazz = Config.getProperty("filter.SSOClientFilter.sso.client.function.limit");
        if (clazz == null || clazz.trim().length() == 0) {
            return null;
        }
        try {
            return (IFunctionLimitClient)Class.forName(clazz).newInstance();
        }
        catch (Exception ex) {
            log.log(9993, (Object)ex.getMessage());
            return null;
        }
    }

    private void addCrossHeader(HttpServletResponse response) {
        String s = response.getHeader("Access-Control-Allow-Origin");
        if (s == null) {
            response.getHeader("access-control-allow-origin");
        }
        if (s == null) {
            response.addHeader("Access-Control-Allow-Origin", "*");
        }
        response.addHeader("Access-Control-Allow-Headers", "token");
    }

    private boolean ignoreValidation(String strURI) {
        boolean bl;
        String regx;
        int nIndex = strURI.lastIndexOf(".");
        String strTemp = strURI;
        if (nIndex > 0) {
            strTemp = strTemp.substring(0, nIndex);
        }
        if (strTemp.endsWith("Select") || strTemp.endsWith("Frame")) {
            return true;
        }
        for (String m : no_validation_modules) {
            if (m.indexOf("*") < 0) {
                if (!strURI.startsWith(m)) continue;
                return true;
            }
            regx = m.replaceAll("\\*", ".+");
            bl = strURI.matches("^" + regx + "$");
            if (!bl) continue;
            return true;
        }
        for (String e : no_validation_urls) {
            if (e.indexOf("*") < 0) {
                if (!strURI.equals(e)) continue;
                return true;
            }
            regx = e.replaceAll("\\*", ".+");
            bl = strURI.matches("^" + regx + "$");
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }
}

