/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.log;

import com.alibaba.fastjson.JSONObject;
import org.slf4j.LoggerFactory;
import team.bangbang.common.log.OperationLog;
import team.bangbang.common.log.RestfulLog;

public class Logger {
    private org.slf4j.Logger log = null;

    public static Logger getInstance(Class<?> clazz) {
        org.slf4j.Logger l = LoggerFactory.getLogger(clazz);
        return new Logger(l);
    }

    private Logger(org.slf4j.Logger log) {
        this.log = log;
    }

    public void log(int statusCode, Object object) {
        if (object == null) {
            return;
        }
        String s = JSONObject.toJSONString((Object)object);
        this.log(statusCode, s);
    }

    public void log(OperationLog logData) {
        if (logData == null) {
            return;
        }
        String s = JSONObject.toJSONString((Object)logData);
        this.log.info(s);
    }

    public void log(RestfulLog logData) {
        if (logData == null) {
            return;
        }
        String s = JSONObject.toJSONString((Object)logData);
        this.log(logData.getStatusCode(), s);
    }

    private void log(int code, String s) {
        switch (code) {
            case 100: {
                this.log.info(s);
                return;
            }
            case 200: 
            case 201: 
            case 202: {
                this.log.warn(s);
                return;
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: {
                this.log.error(s);
                return;
            }
            case 400: 
            case 401: 
            case 402: 
            case 403: {
                this.log.error(s);
                return;
            }
            case 500: 
            case 501: 
            case 502: 
            case 503: {
                this.log.info(s);
                return;
            }
            case 1000: 
            case 1001: 
            case 1002: {
                this.log.info(s);
                return;
            }
            case 9990: {
                this.log.debug(s);
                return;
            }
            case 9991: {
                this.log.info(s);
                return;
            }
            case 9992: {
                this.log.warn(s);
                return;
            }
            case 9993: {
                this.log.error(s);
                return;
            }
            case 9994: {
                this.log.error(s);
                return;
            }
        }
        this.log.info(s);
    }
}

