/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.net.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.StringTokenizer;
import team.bangbang.common.net.ftp.FtpInformation;

public class FtpClient {
    private String host = null;
    private int port = 21;
    private String user = "Anonymous";
    private String password = "";
    private Socket socket = null;
    private BufferedWriter writer = null;
    private BufferedReader reader = null;
    FtpInformation info = null;

    public FtpClient(String host) {
        this.host = host;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void connect() throws IOException {
        if (this.socket != null) {
            throw new IOException("FtpClient is already connected. Disconnect first.");
        }
        this.socket = new Socket(this.host, this.port);
        this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
        this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        String response = this.readLine();
        if (!response.startsWith("220 ")) {
            throw new IOException("FtpClient received an unknown response when connecting to the FTP server: " + response);
        }
        this.sendLine("USER " + this.user);
        response = this.readLine();
        if (!response.startsWith("331 ")) {
            throw new IOException("FtpClient received an unknown response after sending the user: " + response);
        }
        this.sendLine("PASS " + this.password);
        response = this.readLine();
        if (!response.startsWith("230 ")) {
            throw new IOException("FtpClient was unable to log in with the supplied password: " + response);
        }
    }

    private void sendLine(String line) throws IOException {
        if (this.socket == null) {
            throw new IOException("FtpClient not connected.");
        }
        try {
            this.writer.write(line + "\r\n");
            this.writer.flush();
        }
        catch (IOException e) {
            this.closeSocket();
            throw e;
        }
    }

    private String readLine() throws IOException {
        return this.reader.readLine();
    }

    public void disconnect() throws IOException {
        try {
            this.sendLine("QUIT");
        }
        catch (IOException ioex1) {
            ioex1.printStackTrace();
        }
        this.closeSocket();
    }

    private void closeSocket() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
            this.socket = null;
        }
    }

    public synchronized String pwd() throws IOException {
        int firstQuote;
        int secondQuote;
        this.sendLine("PWD");
        String dir = null;
        String response = this.readLine();
        if (response.startsWith("257 ") && (secondQuote = response.indexOf(34, (firstQuote = response.indexOf(34)) + 1)) > 0) {
            dir = response.substring(firstQuote + 1, secondQuote);
        }
        return dir;
    }

    public synchronized boolean cwd(String dir) throws IOException {
        this.sendLine("CWD " + dir);
        String response = this.readLine();
        return response.startsWith("250 ");
    }

    public synchronized boolean bin() throws IOException {
        this.sendLine("TYPE I");
        String response = this.readLine();
        return response.startsWith("200 ");
    }

    public synchronized boolean ascii() throws IOException {
        this.sendLine("TYPE A");
        String response = this.readLine();
        return response.startsWith("200 ");
    }

    public synchronized boolean upload(String localFile) throws IOException {
        File file = new File(localFile);
        if (file.isDirectory()) {
            throw new IOException("FtpClient cannot upload a directory.");
        }
        return this.upload(file, file.getName());
    }

    public synchronized boolean upload(File localFile, String remoteFileName) throws IOException {
        this.info = new FtpInformation();
        this.info.setFlag(1);
        this.info.setFileSize(localFile.length());
        this.sendLine("PASV");
        String response = this.readLine();
        if (!response.startsWith("227 ")) {
            throw new IOException("FtpClient could not request passive mode: " + response);
        }
        String dataHost = this.host;
        int dataPort = this.port;
        int opening = response.indexOf(40);
        int closing = response.indexOf(41, opening + 1);
        if (closing > 0) {
            String dataLink = response.substring(opening + 1, closing);
            StringTokenizer tokenizer = new StringTokenizer(dataLink, ",");
            try {
                dataHost = tokenizer.nextToken() + "." + tokenizer.nextToken() + "." + tokenizer.nextToken() + "." + tokenizer.nextToken();
                dataPort = Integer.parseInt(tokenizer.nextToken()) * 256 + Integer.parseInt(tokenizer.nextToken());
            }
            catch (Exception e) {
                throw new IOException("FtpClient received bad data link information: " + response);
            }
        }
        this.sendLine("STOR " + remoteFileName);
        Socket dataSocket = new Socket(dataHost, dataPort);
        response = this.readLine();
        if (!response.startsWith("125 ") && !response.startsWith("150 ")) {
            dataSocket.close();
            throw new IOException("FtpClient was not allowed to send the file: " + response);
        }
        BufferedInputStream input = null;
        FilterOutputStream output = null;
        try {
            input = new BufferedInputStream(new FileInputStream(localFile));
            output = new BufferedOutputStream(dataSocket.getOutputStream());
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            while ((bytesRead = input.read(buffer)) != -1) {
                ((BufferedOutputStream)output).write(buffer, 0, bytesRead);
                ((BufferedOutputStream)output).flush();
                this.info.setCompleteSize(this.info.getCompleteSize() + (long)bytesRead);
            }
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (Exception exception) {}
            }
            if (dataSocket != null) {
                try {
                    dataSocket.close();
                }
                catch (Exception exception) {}
            }
        }
        response = this.readLine();
        return response.startsWith("226 ");
    }

    public FtpInformation getFtpInformation() {
        return this.info;
    }
}

