/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.queue;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import team.bangbang.common.config.Config;
import team.bangbang.common.queue.IQueueManager;
import team.bangbang.common.queue.Publisher;
import team.bangbang.common.queue.Subscriber;
import team.bangbang.common.queue.kafka.KafkaManager;
import team.bangbang.common.queue.rabbit.RabbitManager;
import team.bangbang.common.redis.RedisUtil;

public class QueueProxy {
    private static Map<String, Set<String>> subscribers = new HashMap<String, Set<String>>();
    private static final String KEY_PREFIX = "SUBSCRIBER_UNDER_TOPIC:";
    private IQueueManager manager = null;

    public QueueProxy() {
        String mq = Config.getProperty("spring.mq");
        if (mq == null || mq.trim().length() == 0) {
            mq = "rabbit";
        }
        if ((mq = mq.trim()).equalsIgnoreCase("rabbit")) {
            this.manager = new RabbitManager();
        }
        if (mq.equalsIgnoreCase("kafka")) {
            this.manager = new KafkaManager();
        }
    }

    public boolean subscribe(Subscriber subscriber) {
        if (this.manager == null) {
            return false;
        }
        this.manager.subscribe(subscriber);
        String key = KEY_PREFIX + subscriber.getTopic();
        if (RedisUtil.HAS_REDIS) {
            RedisUtil.addIntoSet(key, String.valueOf(subscriber.getIndex()));
        } else {
            Set<String> s = subscribers.get(key);
            if (s == null || s.isEmpty()) {
                s = new HashSet<String>();
                subscribers.put(key, s);
            }
            s.add(String.valueOf(subscriber.getIndex()));
        }
        return false;
    }

    public boolean remove(Subscriber subscriber) {
        if (this.manager == null) {
            return false;
        }
        this.manager.remove(subscriber);
        String key = KEY_PREFIX + subscriber.getTopic();
        if (RedisUtil.HAS_REDIS) {
            RedisUtil.removeFromSet(key, String.valueOf(subscriber.getIndex()));
        } else {
            Set<String> s = subscribers.get(key);
            if (s != null && !s.isEmpty()) {
                s.remove(String.valueOf(subscriber.getIndex()));
            }
        }
        return false;
    }

    public Publisher createPublisher(String topic) {
        if (this.manager == null) {
            return null;
        }
        return this.manager.createPublisher(topic);
    }

    public static int getSubscriberCount(String topic) {
        String key = KEY_PREFIX + topic;
        if (RedisUtil.HAS_REDIS) {
            Set<String> s = RedisUtil.getSet(key);
            return s == null ? 0 : s.size();
        }
        Set<String> s = subscribers.get(key);
        return s == null ? 0 : s.size();
    }
}

