/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.queue.kafka;

import com.alibaba.fastjson.JSONObject;
import java.util.UUID;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import team.bangbang.common.queue.Message;
import team.bangbang.common.queue.Publisher;

public class KafkaPublisher
extends Publisher {
    public KafkaPublisher(Object resource, String topic) {
        super(resource, topic);
    }

    @Override
    public void send(Message<?> message) {
        if (message == null) {
            return;
        }
        message.setId(UUID.randomUUID().toString());
        message.setSendTime(System.currentTimeMillis());
        message.setTopic(this.getTopic());
        Producer producer = (Producer)this.resource;
        if (producer == null) {
            return;
        }
        String strMsg = JSONObject.toJSONString(message);
        ProducerRecord record = new ProducerRecord(this.getTopic(), (Object)strMsg);
        producer.send(record);
        producer.flush();
    }
}

