/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.queue.rabbit;

import com.alibaba.fastjson.JSONObject;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import team.bangbang.common.log.Logger;
import team.bangbang.common.queue.IQueueManager;
import team.bangbang.common.queue.Publisher;
import team.bangbang.common.queue.Subscriber;
import team.bangbang.common.queue.rabbit.RabbitPublisher;
import team.bangbang.common.queue.rabbit.pool.RabbitPool;
import team.bangbang.common.redis.RedisUtil;

public class RabbitManager
implements IQueueManager {
    private Logger log = Logger.getInstance(RabbitManager.class);
    private static Set<String> exchanges = new HashSet<String>();
    private static final String KEY = "RABBIT_EXCHANGES";

    public static String getExchangeName(String topic) {
        return topic + "_Exchange";
    }

    private static String getQueueName(Subscriber subscriber) {
        return subscriber.getTopic() + "_" + subscriber.getIndex();
    }

    private static void checkExchange(String topic) {
        Set<String> s;
        String exchangeName = RabbitManager.getExchangeName(topic);
        if (RedisUtil.HAS_REDIS ? (s = RedisUtil.getSet(KEY)) != null && s.contains(exchangeName) : exchanges.contains(exchangeName)) {
            return;
        }
        RabbitPool rp = new RabbitPool();
        Channel channel = rp.getChannel();
        try {
            channel.exchangeDeclare(exchangeName, "fanout");
            if (RedisUtil.HAS_REDIS) {
                RedisUtil.addIntoSet(KEY, exchangeName);
            } else {
                exchanges.add(exchangeName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Publisher createPublisher(String topic) {
        RabbitManager.checkExchange(topic);
        RabbitPool rp = new RabbitPool();
        Channel channel = rp.getChannel();
        return new RabbitPublisher(channel, topic);
    }

    @Override
    public boolean subscribe(final Subscriber subscriber) {
        String topic = subscriber.getTopic();
        RabbitManager.checkExchange(topic);
        String queueName = RabbitManager.getQueueName(subscriber);
        RabbitPool rp = new RabbitPool();
        Channel channel = null;
        try {
            channel = rp.getChannel();
            this.setExchangeProperty(channel, queueName, RabbitManager.getExchangeName(topic), "fanout");
            DefaultConsumer consumer = new DefaultConsumer(channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    if (envelope.getRoutingKey().equals("fanout")) {
                        String message = new String(body, "UTF-8");
                        JSONObject json = JSONObject.parseObject((String)message);
                        try {
                            subscriber.consume(json);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            RabbitManager.this.log.log(9994, (Object)ex.getMessage());
                        }
                    }
                }
            };
            channel.basicConsume(queueName, true, (Consumer)consumer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    private void setExchangeProperty(Channel channel, String queueName, String exchangeName, String routingKey) {
        try {
            channel.queueDeclare(queueName, true, false, false, null);
            channel.queueBind(queueName, exchangeName, routingKey);
            channel.basicQos(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Subscriber subscriber) {
        if (subscriber == null) {
            return false;
        }
        String quequeName = RabbitManager.getQueueName(subscriber);
        RabbitPool rp = new RabbitPool();
        Channel channel = null;
        try {
            channel = rp.getChannel();
            channel.queueDelete(quequeName);
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }
}

