/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.queue.rabbit;

import com.alibaba.fastjson.JSONObject;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.UUID;
import team.bangbang.common.queue.Message;
import team.bangbang.common.queue.Publisher;
import team.bangbang.common.queue.rabbit.RabbitManager;

public class RabbitPublisher
extends Publisher {
    public RabbitPublisher(Object resource, String topic) {
        super(resource, topic);
    }

    @Override
    public void send(Message<?> message) {
        if (message == null) {
            return;
        }
        message.setId(UUID.randomUUID().toString());
        message.setSendTime(System.currentTimeMillis());
        message.setTopic(this.getTopic());
        try {
            Channel channel = (Channel)this.resource;
            if (channel == null || !channel.isOpen()) {
                return;
            }
            String strMsg = JSONObject.toJSONString(message);
            String exchangeName = RabbitManager.getExchangeName(this.getTopic());
            channel.basicPublish(exchangeName, "fanout", null, strMsg.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

