/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.redis;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import team.bangbang.common.config.Config;
import team.bangbang.common.redis.RedisUtil;
import team.bangbang.common.utility.LogicUtility;

public final class RedisPool {
    private static JedisPool pool = null;

    public static Jedis getJedis() {
        return pool != null ? pool.getResource() : null;
    }

    private static void configure() {
        if (pool != null) {
            return;
        }
        JedisPoolConfig config = new JedisPoolConfig();
        int maxTotal = LogicUtility.parseInt(Config.getProperty("redis.maxTotal"), 100);
        config.setMaxTotal(maxTotal);
        int maxIdle = LogicUtility.parseInt(Config.getProperty("redis.maxIdle"), 5);
        config.setMaxIdle(maxIdle);
        config.setMaxWaitMillis(100000L);
        config.setTestOnBorrow(true);
        String host = Config.getProperty("redis.host");
        int port = LogicUtility.parseInt(Config.getProperty("redis.port"), 6379);
        String password = Config.getProperty("redis.password");
        int database = LogicUtility.parseInt(Config.getProperty("redis.database"), 0);
        pool = new JedisPool((GenericObjectPoolConfig)config, host, port, 2000, password, database);
    }

    static {
        if (RedisUtil.HAS_REDIS) {
            RedisPool.configure();
        }
    }
}

