/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.redis;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import redis.clients.jedis.Jedis;
import team.bangbang.common.config.Config;
import team.bangbang.common.redis.RedisPool;

public final class RedisUtil {
    public static final boolean HAS_REDIS = Config.getProperty("redis.host") != null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setString(String key, String value, int expireSeconds) {
        if (!HAS_REDIS) {
            return;
        }
        if (key == null || key.trim().length() == 0) {
            return;
        }
        Jedis jedis = RedisPool.getJedis();
        if (jedis == null) {
            return;
        }
        try {
            if (value == null) {
                jedis.del(key);
            } else {
                jedis.set(key, value);
                if (expireSeconds > 0) {
                    jedis.expire(key, expireSeconds);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getString(String key) {
        if (!HAS_REDIS) {
            return null;
        }
        if (key == null || key.trim().length() == 0) {
            return null;
        }
        Jedis jedis = RedisPool.getJedis();
        if (jedis == null) {
            return null;
        }
        String value = "";
        try {
            value = jedis.get(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIntoSet(String key, String ... values) {
        if (!HAS_REDIS) {
            return;
        }
        if (key == null || key.trim().length() == 0 || values == null || values.length == 0) {
            return;
        }
        Jedis jedis = RedisPool.getJedis();
        if (jedis == null) {
            return;
        }
        try {
            jedis.sadd(key, values);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getSet(String key) {
        if (!HAS_REDIS) {
            return null;
        }
        if (key == null || key.trim().length() == 0) {
            return Collections.emptySet();
        }
        Jedis jedis = RedisPool.getJedis();
        if (jedis == null) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet();
        try {
            set = jedis.smembers(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int removeFromSet(String key, String ... values) {
        if (!HAS_REDIS) {
            return 0;
        }
        if (key == null || key.trim().length() == 0) {
            return 0;
        }
        Jedis jedis = RedisPool.getJedis();
        if (jedis == null) {
            return 0;
        }
        try {
            int n = (int)jedis.srem(key, values).longValue();
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long lpush(String key, String ... values) {
        if (!HAS_REDIS) {
            return 0L;
        }
        if (key == null || values == null) {
            return 0L;
        }
        Jedis jedis = RedisPool.getJedis();
        if (jedis == null) {
            return 0L;
        }
        try {
            long l = jedis.lpush(key, values);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return 0L;
    }

    public static String rpop(String key) {
        if (!HAS_REDIS) {
            return null;
        }
        if (key == null) {
            return null;
        }
        Jedis jedis = RedisPool.getJedis();
        if (jedis == null) {
            return null;
        }
        try {
            String string = jedis.rpop(key);
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> lrange(String key, long start, long end) {
        if (!HAS_REDIS) {
            return null;
        }
        if (key == null) {
            return null;
        }
        List lst = null;
        try (Jedis jedis = null;){
            jedis = RedisPool.getJedis();
            if (jedis == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            lst = jedis.lrange(key, start, end);
        }
        if (lst == null || lst.size() == 0) {
            return Collections.emptyList();
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long llen(String key) {
        if (!HAS_REDIS) {
            return 0L;
        }
        if (key == null) {
            return 0L;
        }
        Jedis jedis = RedisPool.getJedis();
        if (jedis == null) {
            return 0L;
        }
        try {
            long l = jedis.llen(key);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long scard(String key) {
        if (!HAS_REDIS) {
            return 0L;
        }
        if (key == null) {
            return 0L;
        }
        Jedis jedis = RedisPool.getJedis();
        if (jedis == null) {
            return 0L;
        }
        try {
            long l = jedis.scard(key);
            return l;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> keys(String pattern) {
        if (!HAS_REDIS) {
            return null;
        }
        if (pattern == null || pattern.trim().length() == 0) {
            return null;
        }
        Jedis jedis = RedisPool.getJedis();
        if (jedis == null) {
            return null;
        }
        Set ss = null;
        try {
            ss = jedis.keys(pattern);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return ss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void expire(String key, int seconds) {
        if (!HAS_REDIS) {
            return;
        }
        if (key == null || key.trim().length() == 0 || seconds <= 0) {
            return;
        }
        Jedis jedis = RedisPool.getJedis();
        if (jedis == null) {
            return;
        }
        try {
            jedis.expire(key, seconds);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.close();
            }
        }
    }
}

