/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.service.agent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import team.bangbang.common.service.agent.data.ResponseList;
import team.bangbang.common.service.agent.data.ResponseResult;
import team.bangbang.common.service.agent.data.RestfulAgent;
import team.bangbang.common.utility.LogicUtility;

public class ResponseTransform {
    private JSONObject fromData = null;
    private static Map<String, SimpleDateFormat> sdfMap = new HashMap<String, SimpleDateFormat>();

    public void setFromData(JSONObject fromData) {
        this.fromData = fromData;
    }

    public JSONObject getToData(RestfulAgent ra) {
        if (ra == null || ra.getResponse() == null) {
            return null;
        }
        List<ResponseResult> rrs = ra.getResponse().getResults();
        JSONObject toData = new JSONObject();
        this.doResult(this.fromData, rrs, toData);
        List<ResponseList> rls = ra.getResponse().getLists();
        for (int i = 0; rls != null && i < rls.size(); ++i) {
            ResponseList rl = rls.get(i);
            JSONArray ja1 = this.getJSONArray(this.fromData, rl.getFrom());
            if (ja1 == null || ja1.isEmpty()) continue;
            JSONArray ja2 = new JSONArray();
            this.putJSONArray(toData, rl.getTo(), ja2);
            rrs = rl.getListResults();
            if (rrs.isEmpty()) continue;
            for (int j = 0; ja1 != null && j < ja1.size(); ++j) {
                JSONObject jFrom = ja1.getJSONObject(j);
                JSONObject jTo = new JSONObject();
                this.doResult(jFrom, rrs, jTo);
                ja2.add((Object)jTo);
            }
        }
        return toData;
    }

    private void doResult(JSONObject fData, List<ResponseResult> rrs, JSONObject tData) {
        for (int i = 0; rrs != null && i < rrs.size(); ++i) {
            ResponseResult rr = rrs.get(i);
            String value = this.getValue(fData, rr.getFrom());
            value = this.doFormat(value, rr.getFormat());
            value = this.doDefault(value, rr.getDefaultValue());
            this.setValue(tData, rr.getTo(), value, rr.getMap());
        }
    }

    private String doDefault(String value, String defaultValue) {
        return value != null ? value : defaultValue;
    }

    private String doFormat(String value, String format) {
        long l;
        if (value == null || value.trim().length() == 0 || format == null || format.trim().length() == 0) {
            return value;
        }
        SimpleDateFormat sdf = sdfMap.get(format = format.trim());
        if (sdf == null) {
            sdf = new SimpleDateFormat(format);
            sdfMap.put(format, sdf);
        }
        if ((l = LogicUtility.parseLong(value, 0L)) > 0L) {
            Date d = new Date(l);
            return sdf.format(d);
        }
        Date d = LogicUtility.parseDate(value);
        return d != null ? sdf.format(d) : value;
    }

    private void putJSONArray(JSONObject toData, String to, JSONArray ja) {
        if (toData == null || to == null || ja == null) {
            return;
        }
        int n = to.indexOf(".");
        try {
            if (n < 0) {
                toData.put(to, (Object)ja);
                return;
            }
            String key1 = to.substring(0, n);
            String key2 = to.substring(n + 1);
            JSONObject temp = new JSONObject();
            toData.put(key1, (Object)temp);
            this.putJSONArray(temp, key2, ja);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private JSONArray getJSONArray(JSONObject data, String key) {
        if (data == null || key == null) {
            return null;
        }
        int n = key.indexOf(".");
        try {
            if (n < 0) {
                return data.getJSONArray(key);
            }
            String key1 = key.substring(0, n);
            String key2 = key.substring(n + 1);
            data = data.getJSONObject(key1);
            return this.getJSONArray(data, key2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getValue(JSONObject json, String key) {
        if (json == null || json.isEmpty() || key == null) {
            return null;
        }
        int nIndex = key.indexOf(".");
        if (nIndex < 0) {
            return json.getString(key);
        }
        String key1 = key.substring(0, nIndex);
        String key2 = key.substring(nIndex + 1);
        JSONObject sonMap = json.getJSONObject(key1);
        return this.getValue(sonMap, key2);
    }

    private void setValue(JSONObject json, String key, String value, Map<String, String> map) {
        if (json == null || key == null) {
            return;
        }
        int nIndex = key.indexOf(".");
        if (nIndex < 0) {
            if (map != null && map.containsKey(value)) {
                value = map.get(value);
            }
            json.put(key, (Object)value);
            return;
        }
        String key1 = key.substring(0, nIndex);
        String key2 = key.substring(nIndex + 1);
        JSONObject sonMap = json.getJSONObject(key1);
        if (sonMap == null) {
            sonMap = new JSONObject();
            json.put(key1, (Object)sonMap);
        }
        this.setValue(sonMap, key2, value, map);
    }
}

