/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.service.agent;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jdom.Element;
import team.bangbang.common.file.ResourceLoader;
import team.bangbang.common.file.XMLParser;
import team.bangbang.common.service.agent.data.Forward;
import team.bangbang.common.service.agent.data.Request;
import team.bangbang.common.service.agent.data.RequestParam;
import team.bangbang.common.service.agent.data.Response;
import team.bangbang.common.service.agent.data.ResponseList;
import team.bangbang.common.service.agent.data.ResponseResult;
import team.bangbang.common.service.agent.data.RestfulAgent;
import team.bangbang.common.service.agent.data.RestfulAgents;

public class XmlLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RestfulAgents load(Class<?> clazz, String resourceFile) {
        InputStream is = null;
        try {
            is = ResourceLoader.getInputStream(clazz, resourceFile);
            XMLParser xp = new XMLParser(is);
            Element root = xp.getRootElement();
            RestfulAgents ras = new RestfulAgents();
            List<Element> agents = XMLParser.getChildren(root, "agent");
            for (int i = 0; agents != null && i < agents.size(); ++i) {
                Element agent = agents.get(i);
                RestfulAgent ra = XmlLoader.toRestfulAgent(agent);
                if (ra == null) continue;
                ras.getAgents().add(ra);
            }
            RestfulAgents restfulAgents = ras;
            return restfulAgents;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    private static RestfulAgent toRestfulAgent(Element agent) {
        if (agent == null) {
            return null;
        }
        RestfulAgent ra = new RestfulAgent();
        ra.setName(agent.getChildText("name"));
        Forward forward = new Forward();
        Element ele2 = agent.getChild("forward");
        forward.setUrl(ele2.getAttributeValue("url"));
        forward.setMethod(ele2.getAttributeValue("method"));
        if (forward.getMethod() == null) {
            forward.setMethod("POST");
        }
        ra.setForward(forward);
        Element ele3 = agent.getChild("request");
        Request request = XmlLoader.toRequest(ele3);
        ra.setRequest(request);
        Element ele4 = agent.getChild("response");
        Response response = XmlLoader.toResponse(ele4);
        ra.setResponse(response);
        return ra;
    }

    private static Request toRequest(Element ele) {
        if (ele == null) {
            return null;
        }
        Request req = new Request();
        req.setFrom(ele.getAttributeValue("from"));
        req.setTo(ele.getAttributeValue("to"));
        List<Element> eles = XMLParser.getChildren(ele, "param");
        for (int i = 0; eles != null && i < eles.size(); ++i) {
            Element ep = eles.get(i);
            RequestParam rp = new RequestParam();
            rp.setFrom(ep.getAttributeValue("from"));
            rp.setTo(ep.getAttributeValue("to"));
            req.getParams().add(rp);
        }
        return req;
    }

    private static Response toResponse(Element ele) {
        Element epj;
        int j;
        List<Element> eleMap;
        Element ep;
        int i;
        if (ele == null) {
            return null;
        }
        Response resp = new Response();
        List<Element> eles = XMLParser.getChildren(ele, "result");
        for (i = 0; eles != null && i < eles.size(); ++i) {
            ep = eles.get(i);
            ResponseResult rr = new ResponseResult();
            rr.setFrom(ep.getAttributeValue("from"));
            rr.setTo(ep.getAttributeValue("to"));
            rr.setFormat(ep.getAttributeValue("format"));
            rr.setDefaultValue(ep.getAttributeValue("default"));
            eleMap = XMLParser.getChildren(ep, "map");
            for (j = 0; eleMap != null && j < eleMap.size(); ++j) {
                epj = eleMap.get(j);
                String value = epj.getAttributeValue("value");
                String to = epj.getAttributeValue("to");
                rr.getMap().put(value, to);
            }
            resp.getResults().add(rr);
        }
        eles = XMLParser.getChildren(ele, "list");
        for (i = 0; eles != null && i < eles.size(); ++i) {
            ep = eles.get(i);
            ResponseList rl = new ResponseList();
            rl.setFrom(ep.getAttributeValue("from"));
            rl.setTo(ep.getAttributeValue("to"));
            eleMap = XMLParser.getChildren(ep, "result");
            for (j = 0; eleMap != null && j < eleMap.size(); ++j) {
                epj = eleMap.get(j);
                ResponseResult rr = new ResponseResult();
                rr.setFrom(epj.getAttributeValue("from"));
                rr.setTo(epj.getAttributeValue("to"));
                rr.setFormat(epj.getAttributeValue("format"));
                rr.setDefaultValue(epj.getAttributeValue("default"));
                List<Element> eleMap2 = XMLParser.getChildren(ep, "map");
                for (int j2 = 0; eleMap2 != null && j2 < eleMap2.size(); ++j2) {
                    Element epj2 = eleMap2.get(j2);
                    String value = epj2.getAttributeValue("value");
                    String to = epj2.getAttributeValue("to");
                    rr.getMap().put(value, to);
                }
                rl.getListResults().add(rr);
            }
            resp.getLists().add(rl);
        }
        return resp;
    }
}

