/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.servlet;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import team.bangbang.common.config.Config;
import team.bangbang.common.utility.LogicUtility;

@WebServlet(urlPatterns={"/common/image"})
public class ImageServlet
extends HttpServlet {
    private static final long serialVersionUID = 5571876706562039274L;

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String file = request.getParameter("file");
        if (file == null) {
            return;
        }
        file = LogicUtility.getCNString(file);
        file = Config.getProperty("file.attachment.directory") + "/" + file;
        BufferedImage bufferedImage = ImageIO.read(new File(file));
        int originWidth = bufferedImage.getWidth();
        int originHeight = bufferedImage.getHeight();
        int width = 0;
        int height = 0;
        int scale = LogicUtility.parseInt(request.getParameter("scale"), 0);
        if (scale > 0) {
            width = originWidth * scale / 100;
            height = originHeight * scale / 100;
        } else {
            int maxWidth = LogicUtility.parseInt(request.getParameter("maxWidth"), 0);
            int maxHeight = LogicUtility.parseInt(request.getParameter("maxHeight"), 0);
            if (maxWidth >= originWidth && maxHeight >= originHeight) {
                width = originWidth;
                height = originHeight;
            } else if (maxWidth > 0 && maxHeight > 0) {
                double scale1 = (double)maxWidth / (double)originWidth;
                double scale2 = (double)maxHeight / (double)originHeight;
                if (scale1 < scale2) {
                    width = maxWidth;
                    height = (int)((double)originHeight * scale1);
                } else {
                    height = maxHeight;
                    width = (int)((double)originWidth * scale2);
                }
            }
        }
        if (width == 0 || height == 0) {
            ImageIO.write((RenderedImage)bufferedImage, "JPEG", (OutputStream)response.getOutputStream());
        } else {
            ImageIO.write((RenderedImage)this.resizeImage(bufferedImage, width, height), "JPEG", (OutputStream)response.getOutputStream());
        }
    }

    private BufferedImage resizeImage(BufferedImage originalImage, int scaledWidth, int scaledHeight) {
        BufferedImage scaledBI = new BufferedImage(scaledWidth, scaledHeight, 1);
        Graphics2D g = scaledBI.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage(originalImage, 0, 0, scaledWidth, scaledHeight, null);
        g.dispose();
        return scaledBI;
    }
}

