/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(urlPatterns={"/common/tableau"}, initParams={@WebInitParam(name="tableauServerUrl", value="${tableau.server.url:''}"), @WebInitParam(name="tableauServerUser", value="${tableau.server.user:''}")})
public class TableauServlet
extends HttpServlet {
    private static final long serialVersionUID = 8764087666676523513L;
    private static String tableauServerUrl = null;
    private static String tableauServerUser = null;

    public void init(ServletConfig config) {
        tableauServerUrl = config.getInitParameter("tableauServerUrl");
        if (tableauServerUrl != null && !(tableauServerUrl = tableauServerUrl.trim()).endsWith("/")) {
            tableauServerUrl = tableauServerUrl + "/";
        }
        if ((tableauServerUser = config.getInitParameter("tableauServerUser")) != null) {
            tableauServerUser = tableauServerUser.trim();
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (tableauServerUrl == null || tableauServerUrl.length() == 0) {
            throw new ServletException("The parameter(tableauServerUrl) not found in web.xml");
        }
        if (tableauServerUser == null || tableauServerUser.length() == 0) {
            throw new ServletException("The parameter(tableauServerUser) not found in web.xml");
        }
        String view = request.getParameter("view");
        if (view == null || view.length() == 0) {
            throw new IOException("The parameter(view) not found in this request");
        }
        if (!view.startsWith("/")) {
            view = "/" + view;
        }
        String ip = this.getRemoteIP(request);
        String targetSite = TableauServlet.getTargetSite(view);
        String ticket = TableauServlet.getTrustedTicket(tableauServerUrl, tableauServerUser, targetSite, ip);
        if (ticket == null || ticket.indexOf("==") < 0) {
            throw new IOException("Truested ticket is invalid : [" + ticket + "]");
        }
        ticket = ticket.trim();
        String url = tableauServerUrl + "trusted/" + ticket + view + "?:iid=1&:embed=yes&:toolbar=yes";
        response.setStatus(302);
        response.setHeader("Location", url);
    }

    private static String getTargetSite(String view) {
        if (view == null) {
            return null;
        }
        if (!view.startsWith("/t/")) {
            return null;
        }
        int nIndex = (view = view.substring(3)).indexOf("/");
        if (nIndex <= 0) {
            return null;
        }
        return view.substring(0, nIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getTrustedTicket(String wgserver, String user, String targetSite, String remoteAddr) {
        OutputStreamWriter out = null;
        BufferedReader in = null;
        try {
            StringBuffer data = new StringBuffer();
            data.append(URLEncoder.encode("username", "UTF-8"));
            data.append("=");
            data.append(URLEncoder.encode(user, "UTF-8"));
            if (targetSite != null && targetSite.trim().length() > 0) {
                data.append("&");
                data.append(URLEncoder.encode("target_site", "UTF-8"));
                data.append("=");
                data.append(URLEncoder.encode(targetSite.trim(), "UTF-8"));
            }
            if (remoteAddr != null && remoteAddr.trim().length() > 0) {
                data.append("&");
                data.append(URLEncoder.encode("client_ip", "UTF-8"));
                data.append("=");
                data.append(URLEncoder.encode(remoteAddr.trim(), "UTF-8"));
            }
            URL url = new URL(wgserver + "/trusted");
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            out = new OutputStreamWriter(conn.getOutputStream());
            out.write(data.toString());
            out.flush();
            StringBuffer sb = new StringBuffer();
            in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            while ((line = in.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    protected String getRemoteIP(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        if (request.getHeader("x-forwarded-for") == null) {
            return request.getRemoteAddr();
        }
        return request.getHeader("x-forwarded-for");
    }
}

