/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.servlet;

import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import team.bangbang.common.config.Config;
import team.bangbang.common.data.response.DtoResponse;
import team.bangbang.common.data.response.ResponseBase;
import team.bangbang.common.data.util.Transport;
import team.bangbang.common.file.IFileManager;
import team.bangbang.common.utility.LogicUtility;

@WebServlet(urlPatterns={"/common/upload"})
public class UploadServlet
extends HttpServlet {
    private static final long serialVersionUID = 8966249419259468129L;

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("utf-8");
        response.setContentType("text/html;charset=utf-8");
        HashMap<String, Object> datas = new HashMap<String, Object>();
        Transport.transport(request, datas);
        String folder = (String)datas.get("folder");
        boolean overwrite = "true".equalsIgnoreCase((String)datas.get("overwrite"));
        boolean rename = !"false".equalsIgnoreCase((String)datas.get("rename"));
        String fileManager = (String)datas.get("manager");
        Object[] file = (Object[])datas.get("file");
        boolean isCkeditor = false;
        if (file == null || file.length != 2) {
            file = (Object[])datas.get("upload");
            isCkeditor = true;
        }
        if (file == null || file.length != 2) {
            ResponseBase rb = ResponseBase.SERVICE_FIELD_EXPECTED;
            response.getWriter().print(JSONObject.toJSONString((Object)rb));
            response.getWriter().close();
            return;
        }
        String fileName = this.getFileName((String)file[0]);
        File _file = (File)file[1];
        String remoteFile = null;
        DtoResponse<String> rb = null;
        try {
            IFileManager manager = UploadServlet.getFileManager(fileManager);
            String destSliceFile = this.getDestSliceFile(manager, fileName, folder, rename, overwrite);
            remoteFile = manager.put(_file.getAbsolutePath(), destSliceFile);
            DtoResponse<String> dto = new DtoResponse<String>(100, "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f");
            dto.setDto(remoteFile);
            rb = dto;
        }
        catch (IOException e) {
            e.printStackTrace();
            rb = ResponseBase.ERROR_FILE_OPERATE;
        }
        if (!isCkeditor) {
            response.getWriter().print(JSONObject.toJSONString((Object)rb));
        } else if (remoteFile != null) {
            HashMap<String, Object> mp = new HashMap<String, Object>();
            mp.put("fileName", fileName);
            mp.put("uploaded", 1);
            boolean isFullPath = remoteFile.toLowerCase().startsWith("http://") || remoteFile.toLowerCase().startsWith("https://");
            mp.put("url", isFullPath ? remoteFile : "../common/stream?file=" + remoteFile);
            response.getWriter().print(JSONObject.toJSONString(mp));
        }
        response.getWriter().close();
    }

    private String getDestSliceFile(IFileManager manager, String fileName, String folder, boolean rename, boolean overwrite) throws IOException {
        if (folder == null || folder.length() == 0) {
            folder = LogicUtility.getYearMonth(new Date());
        } else {
            try {
                folder = URLDecoder.decode(folder, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (rename) {
            String ext = LogicUtility.getFileExtension(fileName);
            return folder + "/" + System.currentTimeMillis() + "." + ext;
        }
        fileName = this.getFileName(fileName);
        String sliceFile = folder + "/" + fileName;
        if (overwrite) {
            return sliceFile;
        }
        int nIndex = 0;
        while (manager.exist(sliceFile)) {
            sliceFile = folder + "/" + this.getNextFilePath(fileName, ++nIndex);
        }
        return sliceFile;
    }

    public static IFileManager getFileManager(String fileManager) throws IOException {
        String clazz = fileManager;
        if (clazz == null || clazz.trim().length() == 0) {
            clazz = Config.getProperty("file.attachment.manager");
        }
        if (clazz == null || clazz.trim().length() == 0) {
            clazz = "team.bangbang.common.file.LocalFileManager";
        }
        IFileManager manager = null;
        try {
            manager = (IFileManager)Class.forName(clazz).newInstance();
        }
        catch (Exception ex) {
            throw new IOException("\u6587\u4ef6\u4e0a\u4f20\u3001\u4e0b\u8f7d\u5904\u7406\u5668\u914d\u7f6e\u6709\u8bef\uff01(" + clazz + ")");
        }
        return manager;
    }

    private String getFileName(String p) {
        if (p == null || p.trim().length() == 0) {
            return "";
        }
        int n = p.lastIndexOf("/");
        if (n < 0) {
            n = p.lastIndexOf("\\");
        }
        if (n < 0) {
            return p;
        }
        return p.substring(n + 1);
    }

    private String getNextFilePath(String fileName, int i) {
        if (fileName == null || fileName.trim().length() == 0) {
            return String.valueOf(i);
        }
        int nIndex = fileName.lastIndexOf(".");
        if (nIndex < 0) {
            return fileName + "(" + i + ")";
        }
        String name = fileName.substring(0, nIndex);
        String ext = fileName.substring(nIndex);
        return name + "(" + i + ")" + ext;
    }
}

