/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.servlet;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import team.bangbang.common.servlet.ValidationCode;
import team.bangbang.common.utility.LogicUtility;

@WebServlet(urlPatterns={"/common/validationCode"}, initParams={@WebInitParam(name="length", value="5")})
public class ValidationCodeServlet
extends HttpServlet {
    private static final long serialVersionUID = -4752126881820789772L;
    private static final String[] fonts = new String[]{"Arial", "Georgia", "Times New Roman", "Blue", "Yellow"};
    private static int length = 5;

    public void init(ServletConfig config) {
        length = LogicUtility.parseInt(config.getInitParameter("length"), 4);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int fontSize = LogicUtility.parseInt(request.getParameter("fontSize"), 30);
        int padding = LogicUtility.parseInt(request.getParameter("padding"), 0);
        boolean chaos = !"false".equalsIgnoreCase(request.getParameter("chaos"));
        String temp = request.getParameter("chaosColor");
        Color chaosColor = LogicUtility.parseColor(temp, Color.lightGray);
        temp = request.getParameter("background");
        Color background = LogicUtility.parseColor(temp, Color.white);
        temp = request.getParameter("winding");
        double winding = LogicUtility.parseDouble(temp, Math.PI * 2);
        boolean onlyNumber = !"false".equalsIgnoreCase(request.getParameter("onlyNumber"));
        ValidationCode.CodeEntity ce = ValidationCode.getCodeEntity(length, onlyNumber);
        request.getSession(true).setAttribute("KEY_VALIDATION_CODE", (Object)ce);
        String code = ce.letter;
        int width = length * (fontSize + padding) + padding + 4;
        int height = fontSize + padding * 2 + 4 + length;
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics g = image.getGraphics();
        g.setColor(background);
        g.fillRect(0, 0, width, height);
        Random random = new Random();
        if (chaos) {
            int c = length * 10;
            for (int i = 0; i < c; ++i) {
                int x = random.nextInt(width);
                int y = random.nextInt(height);
                g.setColor(chaosColor);
                g.drawRect(x, y, 1, 1);
            }
        }
        int fHeight = (int)((double)fontSize / 1.5);
        int vMiddle = height / 2 + fHeight / 2;
        for (int i = 0; i < length; ++i) {
            int findex = random.nextInt(fonts.length);
            Font font = new Font(fonts[findex], 1, fontSize);
            g.setFont(font);
            int left = i * (fontSize + padding) + padding + (fontSize - fHeight) / 2;
            int top = i % 2 == 0 ? vMiddle - length / 2 : vMiddle + length / 2;
            g.setColor(this.getRandomColor(10 + i, 120 - i));
            g.drawString(String.valueOf(code.charAt(i)), left, top);
        }
        this.shear(g, width, height, background, winding);
        g.dispose();
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
        ImageIO.write((RenderedImage)image, "jpg", (OutputStream)response.getOutputStream());
        response.getOutputStream().close();
    }

    private Color getRandomColor(int start, int end) {
        Random random = new Random();
        if (start > 255) {
            start = 255;
        }
        if (end > 255) {
            end = 255;
        }
        int rang = Math.abs(end - start);
        int r = start + random.nextInt(rang);
        int g = start + random.nextInt(rang);
        int b = start + random.nextInt(rang);
        return new Color(r, g, b);
    }

    private void shear(Graphics g, int w1, int h1, Color background, double winding) {
        double d;
        int i;
        Random random = new Random();
        int period = random.nextInt(2);
        boolean borderGap = true;
        int frames = 1;
        int phase = random.nextInt(2);
        for (i = 0; i < h1; ++i) {
            d = (double)(period >> 1) * Math.sin((double)i / (double)period + winding * (double)phase / (double)frames);
            g.copyArea(0, i, w1, 1, (int)d, 0);
            if (!borderGap) continue;
            g.setColor(background);
            g.drawLine((int)d, i, 0, i);
            g.drawLine((int)d + w1, i, w1, i);
        }
        period = random.nextInt(16);
        frames = 20;
        phase = 3;
        for (i = 0; i < w1; ++i) {
            d = (double)(period >> 1) * Math.sin((double)i / (double)period + winding * (double)phase / (double)frames);
            g.copyArea(i, 0, 1, h1, 0, (int)d);
            if (!borderGap) continue;
            g.setColor(background);
            g.drawLine(i, (int)d, i, 0);
            g.drawLine(i, (int)d + h1, i, h1);
        }
    }
}

