/*
 * Decompiled with CFR 0.152.
 */
package team.bangbang.common.sql;

import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import team.bangbang.common.data.Pagination;
import team.bangbang.common.data.RecordData;
import team.bangbang.common.sql.SQLPool;
import team.bangbang.common.sql.generator.IDGenerator;
import team.bangbang.common.utility.LogicUtility;

public final class SQLHelper {
    private Connection conn = null;
    private String alias = null;
    private String databaseName = null;
    public static final int YYYY_MM = 1;
    public static final int MM_DD = 2;
    public static final int YYYY_MM_DD = 3;
    public static final int HH24_MI = 4;
    public static final int HH24_MI_SS = 5;
    public static final int YYYY_MM_DD_HH24_MI = 6;

    public SQLHelper() {
        this("application");
    }

    public SQLHelper(String alias) {
        try {
            this.conn = SQLPool.getConnection(alias);
            this.alias = alias;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    public SQLHelper(Connection conn) {
        this.conn = conn;
    }

    public String getAlias() {
        return this.alias;
    }

    public Connection connection() {
        return this.conn;
    }

    public String getDatabaseName() {
        if (this.databaseName != null) {
            return this.databaseName;
        }
        try {
            DatabaseMetaData dmd = this.conn.getMetaData();
            this.databaseName = dmd.getDatabaseProductName();
        }
        catch (SQLException ex) {
            this.databaseName = "";
        }
        return this.databaseName;
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.conn.getAutoCommit() != autoCommit) {
            this.conn.setAutoCommit(autoCommit);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    public void commit() throws SQLException {
        if (!this.conn.getAutoCommit()) {
            this.conn.commit();
        }
    }

    public void rollback() throws SQLException {
        if (!this.conn.getAutoCommit()) {
            this.conn.rollback();
        }
    }

    public void close() throws SQLException {
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public void querySingleData(String strSql, RecordData data) throws SQLException {
        if (data == null) {
            return;
        }
        ResultSet rs = null;
        Statement st = null;
        try {
            st = this.conn.createStatement();
            String dbName = this.getDatabaseName();
            if ("Oracle".equalsIgnoreCase(dbName)) {
                strSql = "SELECT * FROM (SELECT PAGINATION_.*, ROWNUM RN FROM (" + strSql + ") PAGINATION_ WHERE ROWNUM <= 1) WHERE RN >= 0";
            } else if ("MySQL".equalsIgnoreCase(dbName)) {
                strSql = strSql + " limit 1";
            }
            rs = st.executeQuery(strSql);
            this.readSingleData(rs, data);
        }
        catch (SQLException ex) {
            throw new SQLException(ex.getMessage() + "\n" + strSql);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void queryMultipleData(String strSql, RecordData data, boolean blFilter) throws SQLException {
        if (data == null) {
            return;
        }
        ResultSet rs = null;
        Statement st = null;
        try {
            st = this.conn.createStatement(1004, 1007);
            if (data.getPagination() == null) {
                data.setPagination(new Pagination());
            }
            int n = this.getRecordCount(strSql);
            data.getPagination().setRecordCount(n);
            if (blFilter) {
                String dbName = this.getDatabaseName();
                long nStart = data.getPagination().getStartPosition();
                int maxResult = data.getPagination().getMaxResults();
                if ("Oracle".equalsIgnoreCase(dbName)) {
                    strSql = "SELECT * FROM (SELECT PAGINATION_.*, ROWNUM RN FROM (" + strSql + ") PAGINATION_ WHERE ROWNUM <= " + (nStart + (long)maxResult) + ") WHERE RN > " + nStart;
                } else if ("MySQL".equalsIgnoreCase(dbName)) {
                    strSql = strSql + " limit " + nStart + ", " + maxResult;
                }
            }
            rs = st.executeQuery(strSql);
            this.readMultipleData(rs, data);
        }
        catch (SQLException ex) {
            throw new SQLException(ex.getMessage() + "\n" + strSql);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public int getRecordCount(String strSql) throws SQLException {
        ResultSet rs = null;
        Statement st = null;
        int nCount = 0;
        try {
            st = this.conn.createStatement();
            strSql = strSql.replaceAll("\\s+", " ");
            String upStr = strSql.toUpperCase();
            int nIndex = upStr.indexOf(" ORDER ");
            if (nIndex > 0) {
                strSql = strSql.substring(0, nIndex);
            }
            if ((nIndex = upStr.indexOf(" FROM ")) < 0) {
                int n = 1;
                return n;
            }
            strSql = "SELECT COUNT(*) " + strSql.substring(nIndex);
            String dbName = this.getDatabaseName();
            if (!("Oracle".equalsIgnoreCase(dbName) || "MySQL".equalsIgnoreCase(dbName) || "Microsoft SQL Server".equalsIgnoreCase(dbName) || "ACCESS".equalsIgnoreCase(dbName))) {
                throw new SQLException("Please config SQL to COUNT records for DB:" + dbName);
            }
            rs = st.executeQuery(strSql);
            if (rs != null && rs.next()) {
                nCount = rs.getInt(1);
            }
        }
        catch (SQLException ex) {
            throw new SQLException(ex.getMessage() + "\n" + strSql);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return nCount;
    }

    public int delete(RecordData ds) throws SQLException {
        String strTable = ds.getTable();
        int nRetValue = -1;
        String strWhere = ds.getSubWhere();
        String strField = null;
        Set<String> keys = ds.singleDataKeys();
        if (strWhere == null && (keys == null || keys.size() == 0)) {
            throw new SQLException("Condition data is expected in SQLHelper.delete(RecordData)");
        }
        if (keys != null) {
            Iterator<String> it = keys.iterator();
            while (it.hasNext()) {
                strWhere = strWhere == null ? "" : strWhere + " and ";
                strField = it.next();
                strWhere = strWhere + strField + " = " + this.getSQLValue(ds.getSingleData(strField));
            }
        }
        nRetValue = this.executeUpdate("delete from " + strTable + " where " + strWhere);
        return nRetValue;
    }

    public int insert(RecordData ds) throws SQLException {
        return this.insert(ds, true);
    }

    public int insert(RecordData ds, boolean autoPK) throws SQLException {
        String strTable = ds.getTable();
        int nRetValue = -1;
        if (autoPK) {
            IDGenerator.generateId(this, ds);
        }
        String strFields = null;
        String strValues = null;
        String strField = null;
        Set<String> keys = ds.singleDataKeys();
        if (keys == null || keys.size() == 0) {
            throw new SQLException("Record data is expected SQLHelper.insert(RecordData).");
        }
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            if (strFields == null) {
                strFields = "";
                strValues = "";
            } else {
                strFields = strFields + ", ";
                strValues = strValues + ", ";
            }
            strField = it.next();
            strFields = strFields + strField;
            strValues = strValues + this.getSQLValue(ds.getSingleData(strField));
        }
        nRetValue = this.executeUpdate("insert into " + strTable + "(" + strFields + ") values(" + strValues + ")");
        return nRetValue;
    }

    public int update(RecordData ds) throws SQLException {
        String strTable = ds.getTable();
        String strCondition = ds.getSubWhere();
        if (strCondition == null || strCondition.trim().length() == 0) {
            throw new SQLException("Sub-where statement expected in SQLHelper.update(RecordData)!");
        }
        int nRetValue = -1;
        String strBody = null;
        String strField = null;
        Set<String> keys = ds.singleDataKeys();
        if (keys == null || keys.size() == 0) {
            throw new SQLException("Record data to be updated is expected in SQLHelper.update(RecordData).");
        }
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            strBody = strBody == null ? "" : strBody + ", ";
            strField = it.next();
            strBody = strBody + strField + " = " + this.getSQLValue(ds.getSingleData(strField));
        }
        nRetValue = this.executeUpdate("UPDATE " + strTable + " SET " + strBody + " WHERE " + strCondition);
        return nRetValue;
    }

    public int executeUpdate(String strSql) throws SQLException {
        int nRetValue = -1;
        Statement st = null;
        try {
            st = this.conn.createStatement();
            nRetValue = st.executeUpdate(strSql);
        }
        catch (SQLException ex) {
            throw new SQLException(ex.getMessage() + "\n" + strSql);
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return nRetValue;
    }

    private void readSingleData(ResultSet sourceData, RecordData data) throws SQLException {
        if (sourceData == null || data == null) {
            return;
        }
        ResultSetMetaData col = sourceData.getMetaData();
        String[] arrColName = new String[col.getColumnCount()];
        for (int i = 0; i < arrColName.length; ++i) {
            arrColName[i] = col.getColumnLabel(i + 1);
        }
        Object objValue = null;
        if (sourceData.next()) {
            for (int j = 0; j < arrColName.length; ++j) {
                switch (col.getColumnType(j + 1)) {
                    case 91: 
                    case 92: 
                    case 93: {
                        objValue = sourceData.getTimestamp(arrColName[j]);
                        break;
                    }
                    case 2005: {
                        objValue = sourceData.getClob(arrColName[j]);
                        break;
                    }
                    case 2004: {
                        objValue = sourceData.getBlob(arrColName[j]);
                        break;
                    }
                    default: {
                        objValue = sourceData.getObject(arrColName[j]);
                    }
                }
                data.setSingleData(arrColName[j].toLowerCase(), objValue);
            }
        }
    }

    private void readMultipleData(ResultSet sourceData, RecordData data) throws SQLException {
        ResultSetMetaData col = sourceData.getMetaData();
        String[] arrColName = new String[col.getColumnCount()];
        for (int i = 0; i < arrColName.length; ++i) {
            arrColName[i] = col.getColumnLabel(i + 1);
        }
        Object objValue = null;
        while (sourceData.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int j = 0; j < arrColName.length; ++j) {
                switch (col.getColumnType(j + 1)) {
                    case 91: 
                    case 92: 
                    case 93: {
                        objValue = sourceData.getTimestamp(arrColName[j]);
                        break;
                    }
                    case 2005: {
                        objValue = sourceData.getClob(arrColName[j]);
                        break;
                    }
                    case 2004: {
                        objValue = sourceData.getBlob(arrColName[j]);
                        break;
                    }
                    default: {
                        objValue = sourceData.getObject(arrColName[j]);
                    }
                }
                row.put(arrColName[j].toLowerCase(), objValue);
            }
            data.addMultipleData(row);
        }
    }

    private String getSQLValue(Object obj) throws SQLException {
        if (obj == null) {
            return "null";
        }
        String dbName = this.getDatabaseName();
        if (obj instanceof String) {
            return "'" + LogicUtility.getDataString((String)obj, this.getDatabaseName()) + "'";
        }
        if (obj instanceof Integer || obj instanceof Short || obj instanceof Byte || obj instanceof Long || obj instanceof BigDecimal) {
            return obj.toString();
        }
        if (obj instanceof Float || obj instanceof Double) {
            String str = obj.toString();
            return new BigDecimal(str).toString();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? "1" : "0";
        }
        if ("Oracle".equalsIgnoreCase(dbName)) {
            return this.getOracleSQLValue(obj);
        }
        if ("MySQL".equalsIgnoreCase(dbName)) {
            return this.getMySQLValue(obj);
        }
        if ("Microsoft SQL Server".equalsIgnoreCase(dbName)) {
            return this.getSQLServerValue(obj);
        }
        if ("ACCESS".equalsIgnoreCase(dbName)) {
            return this.getSQLServerValue(obj);
        }
        throw new SQLException("\u8bf7\u5728" + this.getClass().getName() + "\u4e2d\u914d\u7f6e" + dbName + "\u6570\u636e\u5e93\u7684SQL\u8f6c\u6362\uff01");
    }

    private String getMySQLValue(Object obj) throws SQLException {
        if (obj instanceof Date) {
            return this.getDBTimeValue((Date)obj);
        }
        throw new SQLException("An unkown type of field value is encountered.");
    }

    private String getOracleSQLValue(Object obj) throws SQLException {
        if (obj instanceof Date) {
            return this.getDBTimeValue((Date)obj);
        }
        if (obj instanceof Clob) {
            return "EMPTY_CLOB()";
        }
        throw new SQLException("An unkown type of field value is encountered.");
    }

    private String getSQLServerValue(Object obj) throws SQLException {
        if (obj instanceof Date) {
            return this.getDBTimeValue((Date)obj);
        }
        throw new SQLException("An unkown type of field value is encountered.");
    }

    public String getDBDateValue(Date dt) {
        String dbName = this.getDatabaseName();
        return SQLHelper.getDBDateValue(dbName, dt);
    }

    public static String getDBDateValue(String dbName, Date dt) {
        if ("Oracle".equalsIgnoreCase(dbName)) {
            return "TO_DATE('" + LogicUtility.getDateAsString(dt) + "', 'yyyy-mm-dd')";
        }
        return "'" + LogicUtility.getDateAsString(dt) + "'";
    }

    public String getDBTimeValue(Date dt) {
        String dbName = this.getDatabaseName();
        return SQLHelper.getDBTimeValue(dbName, dt);
    }

    public static String getDBTimeValue(String dbName, Date dt) {
        if ("Oracle".equalsIgnoreCase(dbName)) {
            return "TO_DATE('" + LogicUtility.getTimeAsString(dt) + "', 'yyyy-mm-dd hh24:mi:ss')";
        }
        return "'" + LogicUtility.getTimeAsString(dt) + "'";
    }

    public String formatDateField(String fieldName) {
        String dbName = this.getDatabaseName();
        return SQLHelper.formatDateField(dbName, fieldName);
    }

    public static String formatDateField(String dbName, String fieldName) {
        return SQLHelper.formatDateField(dbName, fieldName, 3);
    }

    public static String formatDateField(String dbName, String fieldName, int style) {
        switch (style) {
            case 1: {
                if ("Oracle".equalsIgnoreCase(dbName)) {
                    return "TO_CHAR(" + fieldName + ", 'yyyy-MM')";
                }
                if ("MySQL".equalsIgnoreCase(dbName)) {
                    return "DATE_FORMAT(" + fieldName + ", '%Y-%m')";
                }
                if (!"Microsoft SQL Server".equalsIgnoreCase(dbName)) break;
                return "CONVERT(varchar(7), " + fieldName + ", 23)";
            }
            case 2: {
                if ("Oracle".equalsIgnoreCase(dbName)) {
                    return "TO_CHAR(" + fieldName + ", 'MM-dd')";
                }
                if ("MySQL".equalsIgnoreCase(dbName)) {
                    return "DATE_FORMAT(" + fieldName + ", '%m-%d')";
                }
                if (!"Microsoft SQL Server".equalsIgnoreCase(dbName)) break;
                return "CONVERT(varchar(5), " + fieldName + ", 110)";
            }
            case 3: {
                if ("Oracle".equalsIgnoreCase(dbName)) {
                    return "TO_CHAR(" + fieldName + ", 'yyyy-MM-dd')";
                }
                if ("MySQL".equalsIgnoreCase(dbName)) {
                    return "DATE_FORMAT(" + fieldName + ", '%Y-%m-%d')";
                }
                if (!"Microsoft SQL Server".equalsIgnoreCase(dbName)) break;
                return "CONVERT(varchar(10), " + fieldName + ", 23)";
            }
            case 4: {
                if ("Oracle".equalsIgnoreCase(dbName)) {
                    return "TO_CHAR(" + fieldName + ", 'hh24:mi')";
                }
                if ("MySQL".equalsIgnoreCase(dbName)) {
                    return "DATE_FORMAT(" + fieldName + ", '%H:%i')";
                }
                if (!"Microsoft SQL Server".equalsIgnoreCase(dbName)) break;
                return "CONVERT(varchar(5), " + fieldName + ", 24)";
            }
            case 5: {
                if ("Oracle".equalsIgnoreCase(dbName)) {
                    return "TO_CHAR(" + fieldName + ", 'hh24:mi:ss')";
                }
                if ("MySQL".equalsIgnoreCase(dbName)) {
                    return "DATE_FORMAT(" + fieldName + ", '%H:%i:%s')";
                }
                if (!"Microsoft SQL Server".equalsIgnoreCase(dbName)) break;
                return "CONVERT(varchar(8), " + fieldName + ", 24)";
            }
            case 6: {
                if ("Oracle".equalsIgnoreCase(dbName)) {
                    return "TO_CHAR(" + fieldName + ", 'yyyy-MM-dd hh24:mi')";
                }
                if ("MySQL".equalsIgnoreCase(dbName)) {
                    return "DATE_FORMAT(" + fieldName + ", '%Y-%m-%d %H:%i')";
                }
                if (!"Microsoft SQL Server".equalsIgnoreCase(dbName)) break;
                return "CONVERT(varchar(16), " + fieldName + ", 20)";
            }
        }
        return fieldName;
    }
}

